/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.loop;

import java.util.LinkedList;
import java.util.List;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.loop.LoopIteration;

public class For
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String key;
    private String from;
    private String to;
    private String step;
    private long sleep;
    private List<ActionElement> body;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public List<ActionElement> getBody() {
        return this.body;
    }

    public void setBody(List<ActionElement> body) {
        this.body = body;
    }

    public long getSleep() {
        return this.sleep;
    }

    public void setSleep(long sleep) {
        this.sleep = sleep;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        String contextName;
        LinkedList<ActionElement> iterations = new LinkedList<ActionElement>();
        if (this.key != null) {
            List<InputElement> list;
            Object o = context.get(this.key);
            if (o instanceof List) {
                list = (List<InputElement>)o;
            } else if (o instanceof Data) {
                Data d = (Data)o;
                list = d.getElements();
            } else {
                throw new ExecuteException("Unsupported data type: " + o);
            }
            contextName = "for[0, " + list.size() + "] from " + this.key;
            for (int for_index = 0; for_index < list.size(); ++for_index) {
                iterations.add(new LoopIteration(for_index, list.get(for_index), this.body, this.sleep));
            }
        } else {
            int localFrom = ContextHelper.getIntParam(this.from, context);
            int localTo = ContextHelper.getIntParam(this.to, context);
            int localStep = this.step != null ? ContextHelper.getIntParam(this.step, context) : 1;
            contextName = "for[" + localFrom + ", " + localTo + "]";
            for (int for_index = localFrom; for_index < localTo; for_index += localStep) {
                iterations.add(new LoopIteration(for_index, null, this.body, this.sleep));
            }
        }
        ActionContext local = new ActionContext(contextName, context, iterations);
        local.execute();
    }

    public String toString() {
        return "For{key=" + this.key + ", from=" + this.from + ", to=" + this.to + ", step=" + this.step + ", body=" + this.body + '}';
    }
}

