/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.hdw;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.dialog.DialogType;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareException;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.input.model.advanced.messages.B;

public abstract class HardwareAsyncTask
implements AsyncTask {
    private static final long serialVersionUID = 1L;
    protected final ActionContext context;
    protected final String function;
    protected final Map<String, String> params;
    protected final ActionMap actionMap;

    public HardwareAsyncTask(ActionContext context, String function, Map<String, String> params, ActionMap actionMap) {
        if (context == null) {
            throw new NullPointerException("Context is null");
        }
        if (function == null) {
            throw new NullPointerException("Function is null");
        }
        if (params == null) {
            throw new NullPointerException("Params is null");
        }
        if (actionMap == null) {
            throw new NullPointerException("ActionMap is null");
        }
        this.context = context;
        this.function = function;
        this.params = params;
        this.actionMap = actionMap;
    }

    @Override
    public Object execute() {
        try {
            AdvancedHardwareApi hardwareApi = this.context.getEnvironment().getHardwareApi();
            if (hardwareApi == null) {
                throw new HardwareException("AdvancedHardwareApi handler is null");
            }
            return this._execute(hardwareApi);
        }
        catch (Exception ex) {
            return ex;
        }
    }

    protected abstract Response<Data> _execute(AdvancedHardwareApi var1) throws HardwareException;

    @Override
    public void onResult(Object result) {
        if (result instanceof Exception) {
            Exception ex = (Exception)result;
            this.context.getEnvironment().showError(ex);
            this.context.cancelScript();
            Action action = this.actionMap.getActionByType("exception");
            if (action != null) {
                ActionContext local = new ActionContext(this.getContextName(), this.context, action.getSequence());
                local.setTransparent(true);
                local.execute();
            } else {
                this.context.getEnvironment().showError(new Exception("Error function call " + this.function + "(" + this.params + ")", ex));
                this.context.cancelScript();
            }
        } else {
            Response resp = (Response)result;
            if (resp.getServerError() == 0 && resp.getServiceError() == 0) {
                Action action = this.actionMap.getActionByType("success");
                System.out.println("Success action: " + action);
                if (action != null) {
                    ActionContext local = new ActionContext(this.getContextName(), this.context, action.getSequence());
                    if (resp.getData() != null) {
                        Data data = (Data)resp.getData();
                        if (data.getElements() != null) {
                            for (InputElement el : ((Data)resp.getData()).getElements()) {
                                if (local.get(el.getKey()) instanceof InputElement) {
                                    el.setKeyTitle(((InputElement)local.get(el.getKey())).getKeyTitle());
                                }
                                local.put(el.getKey(), el);
                            }
                        }
                        if (data.getSum() != null) {
                            local.put("#sum", data.getSum());
                        }
                        if (data.getNestedData() != null) {
                            local.put(data.getNestedData().getId(), data.getNestedData().getData());
                        }
                    }
                    local.execute();
                } else {
                    this.context.execute();
                }
            } else {
                Action action = this.actionMap.getActionByType("error");
                if (action != null) {
                    ActionContext local = new ActionContext(this.getContextName(), this.context, action.getSequence());
                    local.put("hardware_error", new InputElement("hardware_error", "Device error", "" + resp.getServerError()));
                    if (resp.getData() != null) {
                        Data data = (Data)resp.getData();
                        if (data.getElements() != null) {
                            for (InputElement el : data.getElements()) {
                                local.put(el.getKey(), el);
                            }
                        }
                        if (data.getSum() != null) {
                            local.put("#sum", data.getSum());
                        }
                        if (data.getNestedData() != null) {
                            local.put(data.getNestedData().getId(), data.getNestedData().getData());
                        }
                    }
                    local.setTransparent(true);
                    local.execute();
                } else {
                    LinkedList<ActionElement> actionElements = new LinkedList<ActionElement>();
                    actionElements.add(this.createDialog(resp));
                    ActionContext local = new ActionContext(this.getContextName(), this.context, actionElements);
                    local.execute();
                    this.context.cancelScript();
                }
            }
        }
    }

    private String getContextName() {
        return "hwd request:" + this.function + "(" + this.params + ")";
    }

    public String toString() {
        return "RequestTask{context=" + this.context + ", function=" + this.function + ", params=" + this.params + '}';
    }

    private DialogAction createDialog(Response<?> response) {
        int error;
        String prefix;
        if (response.getServerError() != 0) {
            prefix = "Request.server.";
            error = response.getServerError();
        } else {
            prefix = "Request.service.";
            error = response.getServiceError();
        }
        MessageFormat mf = new MessageFormat(B.get(prefix + "message"));
        DialogAction result = new DialogAction();
        result.setType(DialogType.Error);
        result.setTitle(B.get(prefix + "title"));
        result.setMessage(mf.format(new Object[]{B.get(prefix + error), error}));
        result.setDefaultAction("ok");
        result.setTimeout(10);
        result.setActionMap(new ActionMap(new Action("ok", "OK")));
        return result;
    }
}

