/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.hdw;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.AdvancedHardwareApi;
import ru.softlogic.input.model.advanced.AsyncTask;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.hdw.CardReaderHandler;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareAsyncTask;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareException;
import ru.softlogic.input.model.advanced.actions.hdw.HardwareRequest;
import ru.softlogic.input.model.advanced.actions.request.Response;

public class CardReaderRequest
extends HardwareRequest {
    public static final long serialVersionUID = 0L;

    public CardReaderRequest(String function, List<String> params, ActionMap actionMap) {
        super(function, params, actionMap);
    }

    @Override
    protected AsyncTask _getAsyncTask(ActionContext context, Map<String, String> map) {
        return new RequestTask(context, this.function, map, this.actionMap);
    }

    private class RequestTask
    extends HardwareAsyncTask {
        private static final long serialVersionUID = 1L;

        public RequestTask(ActionContext context, String function, Map<String, String> params, ActionMap actionMap) {
            super(context, function, params, actionMap);
        }

        @Override
        public Response<Data> _execute(AdvancedHardwareApi hardwareApi) throws HardwareException {
            CardReaderHandler crh = hardwareApi.getCardReaderHandler();
            if (crh == null) {
                throw new HardwareException("Cardreader handler is null");
            }
            ArrayList<InputElement> ieList = new ArrayList<InputElement>();
            if ("enable".equals(this.function)) {
                crh.enable();
            } else if ("disable".equals(this.function)) {
                crh.disable();
            } else if ("eject".equals(this.function)) {
                crh.eject();
            } else if ("release".equals(this.function)) {
                crh.release();
            } else if (this.function != null && this.function.startsWith("read-track")) {
                int trackNo = this.function.charAt(this.function.length() - 1) - 48;
                String track = crh.readTrack(trackNo);
                ieList.add(new InputElement("track" + trackNo, "track" + trackNo, track));
            }
            return new Response<Data>(0, 0, new Data(ieList));
        }
    }
}

