/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.conditional;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ContextHelper;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.expression.calculator.CalculateException;
import ru.softlogic.input.model.advanced.expression.calculator.ExpressionCalculator;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class If
implements ActionElement {
    public static final long serialVersionUID = 0L;
    private String expression;
    private String arg1;
    private String arg2;
    private String condition;
    private List<ActionElement> thenElements;
    private List<ActionElement> elseElements;

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<ActionElement> getElseElements() {
        return this.elseElements;
    }

    public void setElseElements(List<ActionElement> elseElements) {
        this.elseElements = elseElements;
    }

    public String getArg1() {
        return this.arg1;
    }

    public void setArg1(String arg1) {
        this.arg1 = arg1;
    }

    public String getArg2() {
        return this.arg2;
    }

    public void setArg2(String arg2) {
        this.arg2 = arg2;
    }

    public List<ActionElement> getThenElements() {
        return this.thenElements;
    }

    public void setThenElements(List<ActionElement> thenElements) {
        this.thenElements = thenElements;
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        ActionContext local;
        if (this.expression != null) {
            local = this.expressionBranch(context);
        } else {
            try {
                local = this.numericBranch(context);
            }
            catch (ExecuteException ex) {
                local = this.stringBranch(context);
                if (local == null) {
                    throw new ExecuteException("Unknown condition(str): '" + this.condition + "'", ex);
                }
            }
            catch (Exception ex) {
                throw new ExecuteException(ex);
            }
        }
        local.execute();
    }

    private ActionContext expressionBranch(ActionContext parentContext) throws ExecuteException {
        try {
            Object result = ExpressionCalculator.calculate(this.expression, parentContext.getData());
            if (result == null) {
                throw new ExecuteException("Result is null");
            }
            if (!(result instanceof Boolean)) {
                throw new ExecuteException("Incorrect result type: " + result.getClass().getName());
            }
            return this.createActionContext("if_" + this.expression, parentContext, (Boolean)result);
        }
        catch (CalculateException ex) {
            throw new ExecuteException(ex.getMessage(), ex);
        }
    }

    private ActionContext numericBranch(ActionContext parentContext) throws ExecuteException {
        String contextName = "if_" + this.arg1 + "_" + this.condition + "_" + this.arg2;
        try {
            BigDecimal v1 = new BigDecimal(ContextHelper.getStringParam(this.arg1, parentContext));
            BigDecimal v2 = new BigDecimal(ContextHelper.getStringParam(this.arg2, parentContext));
            if (">".equals(this.condition) || "gt".equals(this.condition)) {
                return this.createActionContext(contextName, parentContext, v1.compareTo(v2) > 0);
            }
            if ("<".equals(this.condition) || "lt".equals(this.condition)) {
                return this.createActionContext(contextName, parentContext, v1.compareTo(v2) < 0);
            }
            if ("==".equals(this.condition)) {
                return this.createActionContext(contextName, parentContext, v1.compareTo(v2) == 0);
            }
            if ("!=".equals(this.condition)) {
                return this.createActionContext(contextName, parentContext, v1.compareTo(v2) != 0);
            }
            if (">=".equals(this.condition) || "ge".equals(this.condition)) {
                return this.createActionContext(contextName, parentContext, v1.compareTo(v2) >= 0);
            }
            if ("<=".equals(this.condition) || "le".equals(this.condition)) {
                return this.createActionContext(contextName, parentContext, v1.compareTo(v2) <= 0);
            }
        }
        catch (NumberFormatException ex) {
            throw new ExecuteException(ex);
        }
        throw new ExecuteException("Unknown condition(float): '" + this.condition + "'");
    }

    private ActionContext stringBranch(ActionContext context) throws ExecuteException {
        String contextName = "if_" + this.arg1 + "_" + this.condition + "_" + this.arg2;
        if ("==".equals(this.condition)) {
            this.checkArguments(context, this.arg1, this.arg2);
            String var1 = ContextHelper.getStringParam2(this.arg1, context);
            String var2 = ContextHelper.getStringParam2(this.arg2, context);
            return this.createActionContext(contextName, context, var1.equals(var2));
        }
        if ("!=".equals(this.condition)) {
            this.checkArguments(context, this.arg1, this.arg2);
            String var1 = ContextHelper.getStringParam2(this.arg1, context);
            String var2 = ContextHelper.getStringParam2(this.arg2, context);
            return this.createActionContext(contextName, context, !var1.equals(var2));
        }
        if ("is-null".equals(this.condition)) {
            return this.createActionContext(contextName, context, context.get(this.arg1) == null);
        }
        if ("is-not-null".equals(this.condition)) {
            return this.createActionContext(contextName, context, context.get(this.arg1) != null);
        }
        if ("~".equals(this.condition)) {
            if (context.get(this.arg1) == null) {
                throw new ExecuteException(String.format("Argument %s was not found", this.arg1));
            }
            String var1 = ContextHelper.getStringParam2(this.arg1, context);
            if (var1 == null) {
                throw new ExecuteException("Unknown variable '" + this.arg1 + "'");
            }
            String regex = this.arg2.trim();
            if (regex.isEmpty()) {
                throw new ExecuteException("Void regex");
            }
            try {
                return this.createActionContext(contextName, context, var1.matches(regex));
            }
            catch (PatternSyntaxException ex1) {
                throw new ExecuteException("Wrong regex: " + regex, ex1);
            }
        }
        return null;
    }

    private ActionContext createActionContext(String contextName, ActionContext parentContext, boolean conditions) {
        if (conditions) {
            return new ActionContext(contextName, parentContext, this.thenElements);
        }
        return new ActionContext(contextName, parentContext, this.elseElements);
    }

    private void checkArguments(ActionContext context, String arg1, String arg2) throws ExecuteException {
        if (context.get(ContextHelper.replaceParams(arg1, context)) == null && context.get(ContextHelper.replaceParams(arg2, context)) == null) {
            throw new ExecuteException(String.format("%s, %s: both arguments were not found.", arg1, arg2));
        }
    }

    public String toString() {
        return "If{arg1=" + this.arg1 + ", arg2=" + this.arg2 + ", condition=" + this.condition + ", thenElements=" + this.thenElements + ", elseElements=" + this.elseElements + '}';
    }
}

