/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions.cardmodule;

import java.util.Map;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionContext;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.ExecuteException;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleRequestListener;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardModuleResponseData;
import ru.softlogic.input.model.advanced.actions.cardmodule.CardOperation;

public class ExecuteCardModuleTask
implements ActionElement {
    private final boolean ejectCard;
    private final CardOperation operation;
    private ActionMap actionMap;

    public ExecuteCardModuleTask(CardOperation operation, boolean ejectCard) {
        this.operation = operation;
        this.ejectCard = ejectCard;
    }

    public void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public String toString() {
        return "ExecuteCardModuleTask{operation=" + (Object)((Object)this.operation) + '}';
    }

    @Override
    public void execute(ActionContext context) throws ExecuteException {
        context.getEnvironment().executeCardModuleTask(this.operation, this.ejectCard, new LocalCardRequestListener(context));
    }

    private class LocalCardRequestListener
    implements CardModuleRequestListener {
        public static final String MASKED_PAN = "masked-pan";
        public static final String HASH_PAN = "hash-pan";
        public static final String CARD_EXPIRY = "card-expiry";
        private final ActionContext context;

        public LocalCardRequestListener(ActionContext context) {
            this.context = context;
        }

        @Override
        public void onResult(CardModuleResponseData result) {
            if (ExecuteCardModuleTask.this.actionMap == null) {
                return;
            }
            Action act = ExecuteCardModuleTask.this.actionMap.getActionByType("success");
            if (act != null) {
                ActionContext local = new ActionContext("Card Track Read:", this.context, act.getSequence());
                Map<String, Object> data = result.getResult().getData();
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof InputElement)) continue;
                    InputElement ie = (InputElement)value;
                    local.put(entry.getKey(), ie);
                }
                local.put(MASKED_PAN, new InputElement(MASKED_PAN, MASKED_PAN, result.getMaskedPan()));
                local.put(HASH_PAN, new InputElement(HASH_PAN, HASH_PAN, result.getHashPan()));
                local.put(CARD_EXPIRY, new InputElement(CARD_EXPIRY, CARD_EXPIRY, result.getExpirationDateAsString()));
                local.execute();
            } else {
                this.context.cancelScript();
            }
        }

        @Override
        public void onError(Exception ex) {
            if (ExecuteCardModuleTask.this.actionMap == null) {
                return;
            }
            Action act = ExecuteCardModuleTask.this.actionMap.getActionByType("error");
            if (act != null) {
                ActionContext local = new ActionContext("Card Track Read:", this.context, act.getSequence());
                local.execute();
            } else {
                this.context.cancelScript();
            }
        }
    }
}

