/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model.advanced.actions;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.input.model.advanced.Environment;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ExecuteException;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActionContext
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final String SUM = "#sum";
    public static final String SUM_MIN = "#sum-min";
    public static final String SUM_MAX = "#sum-max";
    public static final String SUM_DEPOSIT_MAX = "#sum-deposit-max";
    public static final String SUM_MIN_WITH_NOTE_LIMIT = "#sum-min-limit";
    public static final String SUM_DONATE = "#sum-donate";
    public static final String FROM = "#from";
    public static final String FEE_SUM = "#fee-sum";
    private Environment environment;
    private ActionContext parent;
    private Map<String, Object> data;
    private List<ActionElement> actions;
    private int index;
    private String name;
    private boolean transparent;
    private transient Runnable cancelListener;
    private short idService;

    public ActionContext() {
    }

    public ActionContext(Environment environment, Runnable cancelListener, List<ActionElement> actions, Map<String, Object> data, short idService) {
        if (environment == null) {
            throw new NullPointerException("Environment not set");
        }
        if (actions == null) {
            throw new NullPointerException("ActionElement list not set");
        }
        if (data == null) {
            throw new NullPointerException("Data not set");
        }
        this.name = "global";
        this.environment = environment;
        this.cancelListener = cancelListener;
        this.actions = actions;
        this.data = data;
        this.idService = idService;
    }

    public ActionContext(String name, ActionContext parent, List<ActionElement> actions) {
        if (parent == null) {
            throw new NullPointerException("Parent actionContext not set");
        }
        if (actions == null) {
            throw new NullPointerException("ActionElement list not set");
        }
        this.name = name;
        this.parent = parent;
        this.actions = actions;
        this.data = new HashMap<String, Object>();
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public String getName() {
        return this.name;
    }

    public void put(String key, Object value) {
        this.data.put(key, value);
    }

    public void putAll(Map<String, Object> data) {
        this.data.putAll(data);
    }

    public Map<String, Object> getData() {
        if (this.parent != null) {
            Map<String, Object> result = this.parent.getData();
            result.putAll(this.data);
            return result;
        }
        return new HashMap<String, Object>(this.data);
    }

    public Object get(String key) {
        Object object = this.data.get(key);
        if (object != null) {
            return object;
        }
        if (this.parent != null) {
            return this.parent.get(key);
        }
        return null;
    }

    public Object remove(String key) {
        Object object = this.data.remove(key);
        if (object != null) {
            return object;
        }
        if (this.parent != null) {
            return this.parent.remove(key);
        }
        return null;
    }

    public void execute() {
        if (this.index < this.actions.size()) {
            try {
                int i = this.index++;
                this.actions.get(i).execute(this);
            }
            catch (ExecuteException ex) {
                this.getEnvironment().showError(ex);
                this.cancelScript();
            }
        } else if (this.parent != null) {
            if (!this.transparent) {
                this.parent.data.putAll(this.data);
            }
            this.data.clear();
            this.parent.execute();
        }
    }

    public void merge() {
        if (this.parent != null) {
            if (!this.transparent) {
                this.parent.data.putAll(this.data);
            }
            this.data.clear();
            this.parent.merge();
        }
    }

    public Environment getEnvironment() {
        if (this.parent != null) {
            return this.parent.getEnvironment();
        }
        return this.environment;
    }

    public short getIdService() {
        if (this.parent != null) {
            return this.parent.getIdService();
        }
        return this.idService;
    }

    public void finishScript(String nextScreen) {
        if (this.parent != null) {
            if (!this.transparent) {
                this.parent.data.putAll(this.data);
            }
            this.data.clear();
            this.parent.finishScript(nextScreen);
        } else {
            this.environment.showScreen(nextScreen, this.data);
        }
    }

    public void cancelScript() {
        if (this.parent != null) {
            this.parent.cancelScript();
        } else if (this.cancelListener != null) {
            this.cancelListener.run();
        }
    }
}

