/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.input.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import ru.softlogic.input.model.InputElementConsts;
import ru.softlogic.keeper.annotation.documentation.TypeDoc;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@TypeDoc(value="\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0432\u0432\u043e\u0434\u0430")
public class InputElement
extends InputElementConsts
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int FLAG_RECEIVED_FROM_SERVER = 0x10000000;
    public static final int FLAG_ATTRIBUTE_ENCRYPTED = 0x40000000;
    private String key;
    private String keyTitle;
    private String keyTitleId;
    private String originalValue;
    private String value;
    private String valueTitle;
    private String valueTitleId;
    private int flags;
    private List<String> alternatives = new LinkedList<String>();

    public InputElement() {
    }

    public InputElement(InputElement oth) {
        if (oth != null) {
            this.key = oth.key;
            this.keyTitle = oth.keyTitle;
            this.keyTitleId = oth.keyTitleId;
            this.originalValue = oth.originalValue;
            this.value = oth.value;
            this.valueTitle = oth.valueTitle;
            this.flags = oth.flags;
        }
    }

    public InputElement(String key, String keyTitle, String value) {
        this(key, keyTitle, value, 0);
    }

    public InputElement(String key, String keyTitle, String value, int flags) {
        this.key = key;
        this.keyTitle = keyTitle;
        this.value = value;
        this.originalValue = value;
        this.valueTitle = value;
        this.flags = flags;
    }

    public InputElement(String key, String keyTitle, String value, String valueTitle, int flags) {
        this(key, keyTitle, value, flags);
        this.valueTitle = valueTitle;
    }

    public InputElement(String key, String keyTitle, String keyTitleId, String value, String valueTitle, int flags) {
        this(key, keyTitle, value, valueTitle, flags);
        this.keyTitleId = keyTitleId;
    }

    public InputElement(String key, String keyTitle, String keyTitleId, String originalValue, String value, String valueTitle, int flags) {
        this(key, keyTitle, keyTitleId, value, valueTitle, flags);
        this.originalValue = originalValue;
    }

    public InputElement(String key, String keyTitle, String keyTitleId, String originalValue, String value, String valueTitle, String titleId, int flags) {
        this(key, keyTitle, keyTitleId, originalValue, value, valueTitle, flags);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlag(int flag) {
        this.flags |= flag;
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) > 0;
    }

    public void removeFlag(Integer flag) {
        this.flags &= ~flag.intValue();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKeyTitle() {
        return this.keyTitle;
    }

    public void setKeyTitle(String keyTitle) {
        this.keyTitle = keyTitle;
    }

    public String getKeyTitleId() {
        return this.keyTitleId;
    }

    public void setKeyTitleId(String keyTitleId) {
        this.keyTitleId = keyTitleId;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValueTitle() {
        return this.valueTitle;
    }

    public void setValueTitle(String valueTitle) {
        this.valueTitle = valueTitle;
    }

    public List<String> getAlternatives() {
        return this.alternatives;
    }

    public void setAlternatives(List<String> alternatives) {
        this.alternatives = alternatives;
    }

    public String getValueTitleId() {
        return this.valueTitleId;
    }

    public void setValueTitleId(String valueTitleId) {
        this.valueTitleId = valueTitleId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputElement other = (InputElement)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.keyTitle == null ? other.keyTitle != null : !this.keyTitle.equals(other.keyTitle)) {
            return false;
        }
        if (this.keyTitleId == null ? other.keyTitleId != null : !this.keyTitleId.equals(other.keyTitleId)) {
            return false;
        }
        if (this.originalValue == null ? other.originalValue != null : !this.originalValue.equals(other.originalValue)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.valueTitle == null ? other.valueTitle != null : !this.valueTitle.equals(other.valueTitle)) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        return this.alternatives == other.alternatives || this.alternatives != null && this.alternatives.equals(other.alternatives);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + (this.key != null ? this.key.hashCode() : 0);
        hash = 61 * hash + (this.keyTitle != null ? this.keyTitle.hashCode() : 0);
        hash = 61 * hash + (this.keyTitleId != null ? this.keyTitleId.hashCode() : 0);
        hash = 61 * hash + (this.originalValue != null ? this.originalValue.hashCode() : 0);
        hash = 61 * hash + (this.value != null ? this.value.hashCode() : 0);
        hash = 61 * hash + (this.valueTitle != null ? this.valueTitle.hashCode() : 0);
        hash = 61 * hash + this.flags;
        hash = 61 * hash + (this.alternatives != null ? this.alternatives.hashCode() : 0);
        return hash;
    }

    public String getMaskedValue() {
        return this.value == null ? null : this.value.replaceAll("(?s).", "*");
    }

    public String toString() {
        if (this.hasFlag(2048)) {
            return "InputElement{k=" + this.key + ", v=" + this.getMaskedValue() + ", f=" + Integer.toBinaryString(this.flags) + '}';
        }
        String log = ", v=" + this.value;
        if (this.originalValue != null && !this.originalValue.equals(this.value)) {
            log = ", ov=" + this.originalValue + log;
        }
        if (this.valueTitle != null && !this.valueTitle.equals(this.value)) {
            log = log + ", vt=" + this.valueTitle;
        }
        return "InputElement{k=" + this.key + log + ", f=" + Integer.toBinaryString(this.flags) + '}';
    }
}

