/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import ru.softlogic.storage.io.BaseSerializatorImpl;
import ru.softlogic.storage.io.FileSet;
import ru.softlogic.storage.io.PathLockException;
import ru.softlogic.storage.io.WrongPathException;

public final class SolidSerializator
extends BaseSerializatorImpl {
    public SolidSerializator(FileSet fileSet) throws WrongPathException, PathLockException {
        super(fileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeObject(Serializable t, File f) {
        block5: {
            RandomAccessFile raf = null;
            ObjectOutputStream oos = null;
            try {
                raf = new RandomAccessFile(f, "rwd");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(t);
                raf.write(baos.toByteArray());
                SolidSerializator.closeQuetly(oos);
            }
            catch (IOException ex) {
                SolidSerializator.notifyException(ex);
                break block5;
            }
            finally {
                SolidSerializator.closeQuetly(oos);
                SolidSerializator.closeQuetly(raf);
            }
            SolidSerializator.closeQuetly(raf);
        }
    }

    public String toString() {
        return "SolidSerializator{}";
    }
}

