/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import ru.softlogic.storage.io.Serializator;

public class SimpleSerializator
extends Serializator {
    private File file;

    public SimpleSerializator(File file) {
        if (file == null) {
            throw new NullPointerException("File must be set");
        }
        this.file = file;
    }

    @Override
    public void writeObject(Serializable object) {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
        }
        SimpleSerializator.writeObjectByStream(object, this.file);
    }

    @Override
    public Object readObject() {
        return SimpleSerializator.readObjectByStream(this.file);
    }

    @Override
    public void close() throws IOException {
    }
}

