/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;

public class SetDataStore<T> {
    private final ObjectIO<HashSet<T>> objectIO;
    private HashSet<T> data;

    public SetDataStore(Serializator serializator) {
        if (serializator == null) {
            throw new NullPointerException("Serializator must be not null");
        }
        this.objectIO = new ObjectIO(serializator);
    }

    public synchronized Set<T> get() {
        this.load();
        return Collections.unmodifiableSet(new HashSet<T>(this.data));
    }

    public synchronized void add(T[] newData) {
        if (newData == null || newData.length == 0) {
            throw new IllegalArgumentException("Data must be specify and has elements");
        }
        this.load();
        this.data.addAll(Arrays.asList(newData));
        this.objectIO.write(this.data);
    }

    public synchronized void remove(T element) {
        if (element == null) {
            throw new IllegalArgumentException("Element must be not null");
        }
        this.load();
        if (this.data.remove(element)) {
            this.objectIO.write(this.data);
        }
    }

    private void load() {
        if (this.data == null) {
            this.data = this.objectIO.read(new HashSet());
        }
    }
}

