/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.Serializable;
import ru.softlogic.storage.io.ObjectIO;
import ru.softlogic.storage.io.Serializator;

public class ObjectDataStore<T extends Serializable> {
    private final ObjectIO<T> objectIO;
    private T data;

    public ObjectDataStore(Serializator serializator) {
        if (serializator == null) {
            throw new NullPointerException("Serializator must be not null");
        }
        this.objectIO = new ObjectIO(serializator);
    }

    public synchronized T get() {
        this.load();
        return this.data;
    }

    public synchronized T get(T def) {
        this.load();
        return this.data != null ? this.data : def;
    }

    public synchronized void set(T d) {
        this.load();
        this.data = d;
        this.objectIO.write(this.data);
    }

    private void load() {
        if (this.data == null) {
            this.data = this.objectIO.read();
        }
    }
}

