/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.text.MessageFormat;

public class FileSet {
    private final String baseDir;
    private final String nameTemplate;

    public FileSet(String baseDir, String nameTemplate) {
        if (baseDir == null || baseDir.isEmpty()) {
            throw new IllegalArgumentException("Base dir must be specify");
        }
        if (nameTemplate == null || nameTemplate.isEmpty()) {
            throw new IllegalArgumentException("File name template must be specify");
        }
        if (!nameTemplate.contains("{0}")) {
            throw new IllegalArgumentException("File name template must be contain {0}");
        }
        if (nameTemplate.contains("/") || nameTemplate.contains("\\")) {
            throw new IllegalArgumentException("Template must be contain only name");
        }
        this.baseDir = this.normalize(baseDir);
        this.nameTemplate = nameTemplate;
    }

    private String normalize(String path) {
        String p = path + "/";
        return p.replace("\\", "/").replaceAll("/{2,}", "/");
    }

    public String getDir() {
        return this.baseDir;
    }

    public String getMainFile() {
        return MessageFormat.format(this.nameTemplate, "_main") + ".storage";
    }

    public String getBackupFile() {
        return MessageFormat.format(this.nameTemplate, "_backup") + ".storage";
    }

    public String getLockFile() {
        return MessageFormat.format(this.nameTemplate, "") + ".lock";
    }
}

