/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import ru.softlogic.storage.io.PathLockException;
import ru.softlogic.storage.io.WrongPathException;

class FileHolder {
    private final File file;
    private final RandomAccessFile raf;
    private final FileLock lock;

    public FileHolder(File file) throws WrongPathException, PathLockException {
        this(file, true);
    }

    public FileHolder(File file, boolean sync) throws WrongPathException, PathLockException {
        this.file = file;
        try {
            this.raf = new RandomAccessFile(file, sync ? "rwd" : "rw");
            FileChannel channel = this.raf.getChannel();
            try {
                this.lock = channel.tryLock();
                if (this.lock == null) {
                    throw new PathLockException("Can't lock " + file.getAbsolutePath());
                }
            }
            catch (OverlappingFileLockException ex) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new PathLockException("Can't lock " + file.getAbsolutePath(), ex);
            }
        }
        catch (IOException ex) {
            throw new WrongPathException("Can't open " + file.getAbsolutePath(), ex);
        }
    }

    public File getFile() {
        return this.file;
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    public void release() {
        try {
            this.lock.release();
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }
}

