/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import ru.softlogic.storage.io.BaseSerializator;
import ru.softlogic.storage.io.FileHolder;
import ru.softlogic.storage.io.FileSet;
import ru.softlogic.storage.io.PathLockException;
import ru.softlogic.storage.io.WrongPathException;

public final class DurableSerializator
extends BaseSerializator {
    private FileHolder mainFile;
    private FileHolder backupFile;

    public DurableSerializator(FileSet fileSet) throws WrongPathException, PathLockException {
        super(fileSet);
        try {
            this.mainFile = new FileHolder(new File(fileSet.getDir(), fileSet.getMainFile()));
            this.backupFile = new FileHolder(new File(fileSet.getDir(), fileSet.getBackupFile()));
        }
        catch (WrongPathException ex) {
            this.release();
            throw ex;
        }
        catch (PathLockException ex) {
            this.release();
            throw ex;
        }
    }

    @Override
    public void writeObjectImpl(Serializable obj) {
        this.writeObject(obj, this.mainFile);
        this.writeObject(obj, this.backupFile);
    }

    @Override
    public final Object readObjectImpl() {
        Object res = this.readObject(this.mainFile);
        if (res == null) {
            res = this.readObject(this.backupFile);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(Serializable object, FileHolder holder) {
        RandomAccessFile file = holder.getRandomAccessFile();
        ObjectOutputStream oos = null;
        try {
            file.setLength(0L);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            file.write(baos.toByteArray());
            DurableSerializator.closeQuetly(oos);
        }
        catch (IOException ex) {
            DurableSerializator.notifyException(ex);
        }
        finally {
            DurableSerializator.closeQuetly(oos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readObject(FileHolder holder) {
        File f = holder.getFile();
        if (!f.isFile()) return null;
        if (f.length() <= 0L) return null;
        RandomAccessFile raf = holder.getRandomAccessFile();
        ObjectInputStream ois = null;
        try {
            raf.seek(0L);
            ois = new ObjectInputStream(new RandomInputStream(raf));
            Object object = ois.readObject();
            DurableSerializator.closeQuetly(ois);
            return object;
        }
        catch (EOFException eOFException) {
            DurableSerializator.closeQuetly(ois);
            return null;
            catch (ClassNotFoundException ex) {
                DurableSerializator.notifyException(ex);
                return null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (IOException ex2) {
                    DurableSerializator.notifyException(ex2);
                    return null;
                }
            }
        }
        finally {
            DurableSerializator.closeQuetly(ois);
        }
    }

    @Override
    public void closeImpl() throws IOException {
        this.release();
    }

    private void release() {
        if (this.mainFile != null) {
            this.mainFile.release();
        }
        if (this.backupFile != null) {
            this.backupFile.release();
        }
    }

    public String toString() {
        return "DurableSerializator{}";
    }

    private class RandomInputStream
    extends InputStream {
        private final RandomAccessFile file;

        public RandomInputStream(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public int read() throws IOException {
            return this.file.read();
        }
    }
}

