/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.storage.cash.StoreUtils;

public class Transfer {
    private short boxFrom;
    private short boxTo;
    private DenominationSet ds;

    public Transfer(short boxFrom, short boxTo, DenominationSet ds) {
        if (boxFrom == boxTo) {
            throw new IllegalArgumentException("BoxFrom must be not equals BoxTo");
        }
        if (ds == null) {
            throw new IllegalArgumentException("Denomination must be specify");
        }
        StoreUtils.checkBoxId(boxFrom);
        StoreUtils.checkBoxId(boxTo);
        this.boxFrom = boxFrom;
        this.boxTo = boxTo;
        this.ds = ds;
    }

    public short getBoxFrom() {
        return this.boxFrom;
    }

    public short getBoxTo() {
        return this.boxTo;
    }

    public DenominationSet getCounts() {
        return this.ds;
    }

    public String toString() {
        return "Transfer{boxFrom=" + this.boxFrom + ", boxTo=" + this.boxTo + ", ds=" + this.ds + '}';
    }
}

