/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import java.util.ResourceBundle;

public class StoreMsg {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(StoreMsg.class.getPackage().getName() + ".messages");

    public static String operTypeAsStr(int type) {
        String key = "operation." + type;
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String boxTypeAsStr(int type) {
        String key = "type." + type;
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String boxFeaturesAsStr(int features) {
        if (features == 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 7; ++i) {
            int flag = 1 << i;
            if ((features & flag) <= 0) continue;
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append(StoreMsg.getFlag(flag));
        }
        return res.toString();
    }

    public static String getFlag(int flag) {
        String key = "feature." + String.format("0x%04x", flag);
        try {
            return bundle.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }
}

