/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import ru.softlogic.storage.cash.StoreMsg;

public class BoxInfo {
    public static final int TYPE_ACC_MAIN = 0;
    public static final int TYPE_ACC_RECYCLER = 1;
    public static final int TYPE_ACC_JAMM = 2;
    public static final int TYPE_DISP_MAIN = 3;
    public static final int TYPE_DISP_REJECT = 4;
    public static final int TYPE_DISP_JAMM = 5;
    public static final int FEATURE_BASE = 0;
    public static final int FEATURE_CAN_EMPTY = 1;
    public static final int FEATURE_CAN_REFILL = 2;
    public static final int FEATURE_SUPPORT_MULTI_DENOMINATION = 4;
    public static final int FEATURE_SUPPORT_MULTI_CURRENCY = 8;
    public static final int FEATURE_CAN_EDIT_CAPACITY = 16;
    public static final int FEATURE_CAN_REFILL_NOT_EMPTY = 32;
    public static final int FEATURE_USE_COINS = 64;
    public static final int FEATURE_USE_BILLS = 0;
    public static final int FEATURE_REJECT_BOX = 13;
    private final int type;
    private final Integer capacity;
    private final int features;
    private final double minimumFilling;
    private final int dispensingAccuracy;

    public BoxInfo(int type, Integer capacity, int features) {
        this(type, capacity, features, 0.0, 0);
    }

    public BoxInfo(int type, Integer capacity, int features, double minimumFilling, int dispensingAccuracy) {
        this.type = type;
        this.capacity = capacity;
        this.features = features;
        this.minimumFilling = minimumFilling;
        this.dispensingAccuracy = dispensingAccuracy;
    }

    public int getType() {
        return this.type;
    }

    public Integer getCapacity() {
        return this.capacity;
    }

    public int getFeatures() {
        return this.features;
    }

    public double getMinimumFilling() {
        return this.minimumFilling;
    }

    public int getDispensingAccuracy() {
        return this.dispensingAccuracy;
    }

    public boolean isFeatureSupport(int feature) {
        return (feature & this.features) != 0;
    }

    public String toString() {
        return "BoxInfo{type=" + StoreMsg.boxTypeAsStr(this.type) + ", capacity=" + this.capacity + ", features=" + StoreMsg.boxFeaturesAsStr(this.features) + ", minimumFilling=" + this.minimumFilling + ", dispensingAccuracy=" + this.dispensingAccuracy + '}';
    }
}

