/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.storage.cash;

import java.io.Serializable;
import ru.softlogic.storage.cash.StoreUtils;

public class BoxId
implements Comparable<BoxId>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final short BOX_0 = 0;
    public static final short BOX_1 = 1;
    public static final short BOX_2 = 2;
    public static final short BOX_3 = 3;
    public static final short BOX_4 = 4;
    public static final short BOX_5 = 5;
    public static final short BOX_6 = 6;
    public static final short BOX_7 = 7;
    public static final short BOX_8 = 8;
    private final short deviceClass;
    private final short deviceNumber;
    private final short boxNumber;

    public BoxId(short deviceClass, short boxNumber) {
        this(deviceClass, 0, boxNumber);
    }

    public BoxId(short deviceClass, short deviceNumber, short boxNumber) {
        if (deviceClass < 0 || deviceClass > 200) {
            throw new IllegalArgumentException("Device class must be in range[0..200]");
        }
        if (deviceNumber < 0 || deviceNumber > 5) {
            throw new IllegalArgumentException("Device number must be in range[0..5]");
        }
        StoreUtils.checkBoxId(boxNumber);
        this.deviceClass = deviceClass;
        this.deviceNumber = deviceNumber;
        this.boxNumber = boxNumber;
    }

    public short getDeviceClass() {
        return this.deviceClass;
    }

    public short getDeviceNumber() {
        return this.deviceNumber;
    }

    public short getBoxNumber() {
        return this.boxNumber;
    }

    public String toString() {
        return "BoxId{deviceClass=" + this.deviceClass + ", deviceNumber=" + this.deviceNumber + ", boxNumber=" + this.boxNumber + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 31 * hash + this.deviceClass;
        hash = 31 * hash + this.deviceNumber;
        hash = 31 * hash + this.boxNumber;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxId other = (BoxId)obj;
        if (this.deviceClass != other.deviceClass) {
            return false;
        }
        if (this.deviceNumber != other.deviceNumber) {
            return false;
        }
        return this.boxNumber == other.boxNumber;
    }

    @Override
    public int compareTo(BoxId oth) {
        if (this.deviceClass == oth.getDeviceClass()) {
            if (this.deviceNumber == oth.getDeviceNumber()) {
                if (this.boxNumber == oth.getBoxNumber()) {
                    return 0;
                }
                return Short.compare(this.boxNumber, oth.getBoxNumber());
            }
            return Short.compare(this.deviceNumber, oth.getDeviceNumber());
        }
        return Short.compare(this.deviceClass, oth.getDeviceClass());
    }
}

