/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.payout.alg.BasePayoutCalculator;
import ru.softlogic.payout.alg.DenominationComparator;
import ru.softlogic.payout.alg.Restriction;

public class GreedyAlgorithmCalculator
extends BasePayoutCalculator {
    @Override
    public DenominationSet calculateImpl(Map<Denomination, Integer> presence, Restriction restriction, int sum, int mode) {
        if (presence == null || presence.isEmpty() || sum <= 0) {
            return new DenominationSet();
        }
        int totalCount = 0;
        for (Integer cnt : presence.values()) {
            if (cnt == null) continue;
            totalCount += cnt.intValue();
        }
        if (totalCount == 0) {
            return new DenominationSet();
        }
        ArrayList<Denomination> lst = new ArrayList<Denomination>(presence.keySet());
        Collections.sort(lst, new DenominationComparator());
        int maxCount = restriction == null ? totalCount : restriction.getMaxCount();
        int currentCount = 0;
        DenominationSet result = new DenominationSet();
        int pSum = sum;
        for (Denomination den : lst) {
            Integer cnt = presence.get(den);
            int rCnt = pSum / den.getNominal();
            rCnt = Math.min(rCnt, cnt);
            if ((rCnt = Math.min(rCnt, maxCount - currentCount)) > 0) {
                currentCount += rCnt;
                result.add(den, rCnt);
                if ((pSum -= den.getNominal() * rCnt) == 0) break;
            }
            if (currentCount != maxCount) continue;
            break;
        }
        return result;
    }
}

