/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout.alg;

import java.util.Map;
import java.util.Random;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.payout.alg.BasePayoutCalculator;
import ru.softlogic.payout.alg.Restriction;

public class GeneticBag
extends BasePayoutCalculator {
    private int[] size;
    private int[] nominal;
    private int[] count;
    private int sizePopulation;
    private String[] population;
    private int countGeneration;
    private int countReproduction;
    private double pm;
    private double pvm;
    private double pv;
    private String best;
    private int req\u0433estSum;
    private Restriction restriction;

    @Override
    public DenominationSet calculateImpl(Map<Denomination, Integer> presence, Restriction restriction, int sum, int mode) {
        this.restriction = restriction;
        this.req\u0433estSum = sum;
        this.generation(presence);
        for (int i = 0; i < this.countGeneration; ++i) {
            this.reproduction();
            this.mutation();
            this.naturalSelection();
            this.selectBest();
        }
        return this.getResult(presence);
    }

    private void generation(Map<Denomination, Integer> presence) {
        this.pm = 0.02;
        this.pvm = 0.99;
        this.pv = 0.98;
        this.size = new int[presence.size()];
        this.nominal = new int[presence.size()];
        this.count = new int[presence.size()];
        this.sizePopulation = 70;
        this.countGeneration = 200;
        this.countReproduction = 20;
        this.population = new String[this.sizePopulation + 2 * this.countReproduction];
        int k = 0;
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            this.nominal[k] = entry.getKey().getNominal();
            this.size[k] = Integer.toBinaryString(this.req\u0433estSum / entry.getKey().getNominal()).length();
            this.count[k] = entry.getValue();
            ++k;
        }
        Random generator = new Random();
        for (int i = 0; i < this.sizePopulation; ++i) {
            StringBuilder organism = new StringBuilder();
            for (int j = 0; j < this.count.length; ++j) {
                StringBuilder temp = new StringBuilder();
                temp.append(Integer.toBinaryString(generator.nextInt(this.size[j] + 1)));
                while (temp.length() < this.size[j]) {
                    temp.insert(0, "0");
                }
                organism.append((CharSequence)temp);
            }
            this.population[i] = organism.toString();
        }
        this.best = this.population[generator.nextInt(this.sizePopulation)];
    }

    private void reproduction() {
        int countParents = this.sizePopulation;
        for (int i = 0; i < this.countReproduction; ++i) {
            Random generator = new Random();
            int father = generator.nextInt(countParents);
            int mother = generator.nextInt(countParents);
            int pointGen = generator.nextInt(this.population[father].length());
            String child = this.population[father].substring(0, pointGen);
            this.population[this.sizePopulation + i * 2] = child = child + this.population[mother].substring(pointGen, this.population[mother].length());
            child = this.population[mother].substring(0, pointGen);
            this.population[this.sizePopulation + i * 2 + 1] = child = child + this.population[father].substring(pointGen, this.population[father].length());
            String swap = this.population[father];
            this.population[father] = this.population[countParents - 1];
            this.population[countParents - 1] = swap;
            swap = this.population[mother];
            this.population[mother] = this.population[countParents - 2];
            this.population[countParents - 2] = swap;
            countParents -= 2;
        }
    }

    private void mutation() {
        Random generator = new Random();
        for (int i = 0; i < this.sizePopulation + 2 * this.countReproduction; ++i) {
            if (!((double)generator.nextInt(100) / 100.0 < this.pm)) continue;
            String mutant = this.invers(this.population[i]);
            if (this.fitness(mutant) < this.fitness(this.population[i])) {
                if (!((double)generator.nextInt(100) / 100.0 > this.pvm)) continue;
                this.population[i] = mutant;
                continue;
            }
            if (!((double)generator.nextInt(100) / 100.0 < this.pvm)) continue;
            this.population[i] = mutant;
        }
    }

    private String invers(String victim) {
        return victim.replace('1', 'x').replace('0', '1').replace('x', '0');
    }

    private double fitness(String victim) {
        if (victim == null) {
            return -1.0E7;
        }
        double sum = 0.0;
        int curr = 0;
        int outSum = 0;
        int[] newCount = new int[this.count.length];
        int totalCount = 0;
        for (int i = 0; i < this.count.length; ++i) {
            newCount[i] = this.getIntFromBinStr(victim.substring(curr, curr + this.size[i]));
            outSum += this.nominal[i] * newCount[i];
            newCount[i] = this.count[i] - newCount[i];
            totalCount = newCount[i];
            if (newCount[i] < 0) {
                return -1.0E7;
            }
            curr += this.size[i];
            sum += (double)this.count[i];
        }
        if ((outSum = this.req\u0433estSum - outSum) < 0) {
            return -1.0E7;
        }
        double ratingSum = outSum == 0 ? 1000000.0 : 100000.0 / (double)outSum;
        sum /= (double)newCount.length;
        double rating = 0.0;
        for (int i = 0; i < newCount.length; ++i) {
            double sq = sum / (double)newCount[i];
            rating *= sq * sq * sq;
        }
        rating = 1.0 - rating;
        return this.restriction.getMaxCount() < totalCount || sum > (double)this.req\u0433estSum ? 1000000.0 : (1.0 - Math.abs(1.0 - rating)) * 1000000.0 + ratingSum;
    }

    private int getIntFromBinStr(String string) {
        int x = 0;
        for (int i = 0; i < string.length(); ++i) {
            x = (int)((double)x + (double)(string.charAt(i) - 48) * Math.pow(2.0, string.length() - 1 - i));
        }
        return x;
    }

    private void naturalSelection() {
        int duels = this.sizePopulation + 2 * this.countReproduction;
        Random generator = new Random();
        for (int i = 0; i < 2 * this.countReproduction; ++i) {
            int rival1 = generator.nextInt(duels);
            String swap = this.population[rival1];
            this.population[rival1] = this.population[--duels];
            this.population[duels] = swap;
            int rival2 = generator.nextInt(duels);
            swap = this.population[rival2];
            this.population[rival2] = this.population[--duels];
            this.population[duels] = swap;
            if (this.fitness(this.population[duels]) < this.fitness(this.population[duels + 1])) {
                if ((double)generator.nextInt(100) / 100.0 < this.pv) {
                    this.population[duels] = null;
                    continue;
                }
                this.population[duels + 1] = null;
                continue;
            }
            if ((double)generator.nextInt(100) / 100.0 < this.pv) {
                this.population[duels + 1] = null;
                continue;
            }
            this.population[duels] = null;
        }
        this.cleanNullOrganism();
    }

    private void cleanNullOrganism() {
        int k = 0;
        for (int i = 0; i < this.sizePopulation + 2 * this.countReproduction; ++i) {
            if (this.population[i] == null) continue;
            this.population[k] = this.population[i];
            ++k;
        }
    }

    private void selectBest() {
        double max = this.fitness(this.best);
        for (int i = 0; i < this.sizePopulation; ++i) {
            double temp = this.fitness(this.population[i]);
            if (!(max < temp)) continue;
            max = temp;
            this.best = this.population[i];
        }
    }

    private DenominationSet getResult(Map<Denomination, Integer> presence) {
        DenominationSet out = new DenominationSet();
        int curr = 0;
        for (int i = 0; i < this.nominal.length; ++i) {
            int countNom = this.getIntFromBinStr(this.best.substring(curr, curr + this.size[i]));
            curr += this.size[i];
            for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
                if (entry.getKey().getNominal() != this.nominal[i] || countNom == 0) continue;
                out.add(entry.getKey(), countNom);
            }
        }
        return out;
    }
}

