/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout.alg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.payout.alg.BasePayoutCalculator;
import ru.softlogic.payout.alg.Restriction;

public class DynamicBag
extends BasePayoutCalculator {
    private int[][] matrix;
    private int[][] numArr;
    private int[][] cost;
    private int[] weight;
    private int[] ans;
    private int[] count;
    private int rows;
    private int cols;
    private int minNom;
    private int mode;

    @Override
    public DenominationSet calculateImpl(Map<Denomination, Integer> presence, Restriction restriction, int sum, int mode) {
        this.mode = mode;
        if (this.init(presence, sum)) {
            this.fillAns();
            this.findAnsRec();
            return this.getResult(presence);
        }
        return new DenominationSet();
    }

    private void fillAns() {
        for (int i = 1; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.matrix[i][j] = this.matrix[i - 1][j];
                for (int k = Math.min(this.count[i], j / this.weight[i]); k > 0; --k) {
                    this.matrix[i][j] = Math.max(this.matrix[i][j], this.matrix[i - 1][j - k * this.weight[i]] + this.cost[i][j - 1] * k);
                    if (this.matrix[i][j] > this.matrix[i - 1][j - k * this.weight[i]] + this.cost[i][j - 1] * k) continue;
                    this.numArr[i][j] = k;
                }
                if (j == 0) continue;
                this.cost[i][j] = (int)((float)this.cost[i][0] * (1.0f - (float)this.numArr[i][j] / 100.0f));
            }
        }
    }

    private void findAnsRec() {
        int optimum = this.matrix[this.rows - 1][this.cols - 1];
        int k = this.rows - 1;
        while (optimum != 0) {
            int j;
            for (j = 0; j < this.matrix[k].length; ++j) {
                if (optimum != this.matrix[k][j]) continue;
                this.ans[k] = this.numArr[k][j];
                break;
            }
            optimum -= this.ans[k] * this.cost[k][j - 1];
            --k;
        }
    }

    private boolean init(Map<Denomination, Integer> presence, int sum) {
        this.rows = 1;
        int avg = 1;
        this.minNom = 1;
        int limit = 0;
        ArrayList<Map.Entry<Denomination, Integer>> boxList = new ArrayList<Map.Entry<Denomination, Integer>>();
        for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            if (entry.getKey().getNominal() > sum) continue;
            boxList.add(entry);
            limit += entry.getKey().getNominal() * entry.getValue();
            this.minNom = this.rows == 1 ? entry.getKey().getNominal() : this.gcd(this.minNom, entry.getKey().getNominal());
            ++this.rows;
            avg += entry.getValue().intValue();
        }
        if (this.rows == 1) {
            return false;
        }
        avg /= this.rows - 1;
        Collections.sort(boxList, new ComparatorImpl());
        this.cols = sum / this.minNom + 1;
        this.matrix = new int[this.rows][this.cols];
        this.numArr = new int[this.rows][this.cols];
        this.ans = new int[this.rows];
        this.cost = new int[this.rows][this.cols];
        this.count = new int[this.rows];
        this.weight = new int[this.rows];
        int temp = 1;
        for (Map.Entry entry : boxList) {
            this.count[temp] = (Integer)entry.getValue();
            this.weight[temp] = ((Denomination)entry.getKey()).getNominal() / this.minNom;
            this.cost[temp][0] = (int)((double)(((Denomination)entry.getKey()).getNominal() * 100) * (1.0 + (double)((float)this.count[temp] - (float)avg) * 0.4 / (double)avg));
            if (this.mode == 2 && temp < boxList.size() && (temp != 1 || boxList.size() <= 2)) {
                int[] nArray = this.cost[temp];
                nArray[0] = (int)((double)nArray[0] * (1.3 - 0.25 / (double)temp));
            }
            if (this.mode == 1 && temp > (boxList.size() + 1) / 2) {
                int[] nArray = this.cost[temp];
                nArray[0] = (int)((double)nArray[0] * 1.3);
            }
            ++temp;
        }
        return true;
    }

    private DenominationSet getResult(Map<Denomination, Integer> presence) {
        DenominationSet result = new DenominationSet();
        block0: for (Map.Entry<Denomination, Integer> entry : presence.entrySet()) {
            for (int i = 1; i < this.rows; ++i) {
                if (this.weight[i] * this.minNom != entry.getKey().getNominal() || this.ans[i] == 0) continue;
                result.add(entry.getKey(), this.ans[i]);
                continue block0;
            }
        }
        return result;
    }

    private int gcd(int a, int b) {
        while (b != 0) {
            int t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private static class ComparatorImpl
    implements Comparator<Map.Entry<Denomination, Integer>> {
        private ComparatorImpl() {
        }

        @Override
        public int compare(Map.Entry<Denomination, Integer> o1, Map.Entry<Denomination, Integer> o2) {
            return o1.getKey().getNominal() - o2.getKey().getNominal();
        }
    }
}

