/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout.alg;

import java.util.Map;
import ru.softlogic.hardware.currency.Denomination;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.payout.alg.PayoutCalculator;
import ru.softlogic.payout.alg.Restriction;

public abstract class BasePayoutCalculator
implements PayoutCalculator {
    @Override
    public DenominationSet calculate(Map<Denomination, Integer> presence, Restriction restriction, int sum) {
        return this.calculate(presence, restriction, sum, 0);
    }

    @Override
    public final DenominationSet calculate(Map<Denomination, Integer> presence, Restriction restriction, int sum, int mode) {
        if (presence == null) {
            throw new NullPointerException("Presence is null");
        }
        if (sum <= 0) {
            throw new IllegalArgumentException("Sum must be positive");
        }
        if (presence.isEmpty()) {
            return new DenominationSet();
        }
        return this.calculateImpl(presence, restriction, sum, mode);
    }

    protected abstract DenominationSet calculateImpl(Map<Denomination, Integer> var1, Restriction var2, int var3, int var4);
}

