/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.softlogic.hardware.currency.Sum;

public class PayoutRequest {
    private final Sum sum;
    private final String algoritm;
    private final Map<Short, Integer> priorityTable;
    private final List<Short> availableDevices;

    public PayoutRequest(Sum sum, String algoritm, Map<Short, Integer> priorityTable, List<Short> availableDevices) {
        this.sum = sum;
        this.algoritm = algoritm;
        this.priorityTable = priorityTable;
        this.availableDevices = availableDevices;
    }

    public Sum getSum() {
        return this.sum;
    }

    public String getAlgoritm() {
        return this.algoritm;
    }

    public Map<Short, Integer> getPriorityTable() {
        return this.priorityTable;
    }

    public List<Short> getAvailableDevices() {
        return this.availableDevices;
    }

    public String toString() {
        return "PayoutRequest{sum=" + this.sum + ", algoritm=" + this.algoritm + ", priorityTable=" + this.priorityTable + ", availableDevices=" + this.availableDevices + '}';
    }

    public static class Builder {
        private final Map<Short, Integer> priorityTable = new HashMap<Short, Integer>();
        private final Sum sum;
        private String algoritm = "greedy";
        private List<Short> availableDevices = null;

        public Builder(Sum sum) {
            this.sum = sum;
        }

        public Builder setAlgoritm(String algoritm) {
            if (algoritm != null) {
                this.algoritm = algoritm;
            }
            return this;
        }

        public Builder addPriority(short deviceClass, int priority) {
            this.priorityTable.put(deviceClass, priority);
            return this;
        }

        public Builder setPriorityTable(Map<Short, Integer> priorityTable) {
            this.priorityTable.clear();
            if (priorityTable != null) {
                this.priorityTable.putAll(priorityTable);
            }
            return this;
        }

        public Builder setAvailableDevices(List<Short> availableDevices) {
            this.availableDevices = new ArrayList<Short>(availableDevices);
            return this;
        }

        public Builder addAvailableDevice(Short deviceClass) {
            if (this.availableDevices == null) {
                this.availableDevices = new ArrayList<Short>();
            }
            this.availableDevices.add(deviceClass);
            return this;
        }

        public PayoutRequest create() {
            return new PayoutRequest(this.sum, this.algoritm, this.priorityTable, this.availableDevices);
        }
    }
}

