/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout;

import java.util.HashMap;
import java.util.List;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashdisp.OperationDispenseResult;
import ru.softlogic.hdw.dev.cashdisp.OperationListener;
import ru.softlogic.payout.PayoutListener;
import ru.softlogic.payout.PayoutResult;
import ru.softlogic.storage.cash.BoxId;

class PayoutAdapter
implements OperationListener {
    private final Sum requested;
    private final Sum confirmed;
    private final PayoutListener listener;
    private final DeviceId deviceId;

    public PayoutAdapter(Sum requested, Sum confirmed, PayoutListener listener, DeviceId deviceId) {
        if (requested == null) {
            throw new NullPointerException("Sum is null");
        }
        if (listener == null) {
            throw new NullPointerException("PayoutListener is null");
        }
        if (deviceId == null) {
            throw new NullPointerException("DeviceId is null");
        }
        this.requested = requested;
        this.confirmed = confirmed;
        this.listener = listener;
        this.deviceId = deviceId;
    }

    @Override
    public void onProgress(List<Sum> sums) {
        this.listener.onProgress(sums);
    }

    @Override
    public void onResult(OperationDispenseResult counts) {
        this.notifyResult(new PayoutResult.DispenseResult(PayoutResult.ResultType.Success, counts.getResult()));
    }

    @Override
    public void onPrepareError() {
        this.notifyResult(new PayoutResult.DispenseResult(PayoutResult.ResultType.Error, new HashMap<BoxId, DenominationSet>()));
    }

    @Override
    public void onError() {
        this.notifyResult(new PayoutResult.DispenseResult(PayoutResult.ResultType.Ambiguity, new HashMap<BoxId, DenominationSet>()));
    }

    private void notifyResult(PayoutResult.DispenseResult result) {
        HashMap<DeviceId, PayoutResult.DispenseResult> res = new HashMap<DeviceId, PayoutResult.DispenseResult>();
        res.put(this.deviceId, result);
        this.listener.onResult(new PayoutResult(this.requested, this.confirmed, result.getDispenced(), res));
    }
}

