/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.payout;

import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.currency.Sum;
import ru.softlogic.hardware.currency.set.DenominationSet;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.cashdisp.OperationDispenseResult;
import ru.softlogic.hdw.dev.cashdisp.OperationListener;
import ru.softlogic.hdw.dev.cashdisp.PayoutBySetOperation;
import ru.softlogic.hdw.dev.cashdisp.PayoutException;
import ru.softlogic.payout.CascadePayoutTask;
import ru.softlogic.payout.PayoutListener;
import ru.softlogic.payout.PayoutResult;
import ru.softlogic.storage.cash.BoxId;

class CascadeOperation {
    private final Sum requested;
    private final Sum confirmed;
    private final Deque<CascadePayoutTask> tasks;
    private final PayoutListener listener;
    private final Map<BoxId, DenominationSet> result = new TreeMap<BoxId, DenominationSet>();
    private final Map<DeviceId, PayoutResult.DispenseResult> results = new LinkedHashMap<DeviceId, PayoutResult.DispenseResult>();
    private static final Logger log = Logger.getLogger(CascadeOperation.class);

    public CascadeOperation(Sum requested, Sum confirmed, Deque<CascadePayoutTask> tasks, PayoutListener listener) {
        this.requested = requested;
        this.confirmed = confirmed;
        this.tasks = tasks;
        this.listener = listener;
    }

    public void start() throws PayoutException {
        CascadePayoutTask task = this.tasks.pollFirst();
        this.processTask(task);
    }

    private void processTask(CascadePayoutTask task) throws PayoutException {
        log.info((Object)("Process next task: " + task.getDispenser().getDeviceId() + "->" + task.getPayout()));
        task.getDispenser().payout(new PayoutBySetOperation(task.getPayout(), new Listener(task.getDispenser().getDeviceId())));
    }

    private void nextTask() {
        if (!this.tasks.isEmpty()) {
            CascadePayoutTask task = this.tasks.pollFirst();
            try {
                this.processTask(task);
            }
            catch (PayoutException ex) {
                this.results.put(task.getDispenser().getDeviceId(), new PayoutResult.DispenseResult(PayoutResult.ResultType.Error, null));
                log.error((Object)"Error on payout", (Throwable)ex);
                this.finish();
            }
        } else {
            log.info((Object)"All tasks complete, notify result");
            this.finish();
        }
    }

    private void finish() {
        log.info((Object)"Payout complete");
        this.listener.onResult(new PayoutResult(this.requested, this.confirmed, this.result, this.results));
    }

    private class Listener
    implements OperationListener {
        private final DeviceId did;

        public Listener(DeviceId did) {
            this.did = did;
        }

        @Override
        public void onProgress(List<Sum> sums) {
            log.info((Object)("Progress: " + sums));
        }

        @Override
        public void onResult(OperationDispenseResult counts) {
            log.info((Object)(this.did + "->success: " + counts));
            CascadeOperation.this.result.putAll(counts.getResult());
            CascadeOperation.this.results.put(this.did, new PayoutResult.DispenseResult(PayoutResult.ResultType.Success, counts.getResult()));
            CascadeOperation.this.nextTask();
        }

        @Override
        public void onPrepareError() {
            log.info((Object)(this.did + "->prepare error"));
            CascadeOperation.this.results.put(this.did, new PayoutResult.DispenseResult(PayoutResult.ResultType.Error, null));
            CascadeOperation.this.finish();
        }

        @Override
        public void onError() {
            log.info((Object)(this.did + "->error"));
            CascadeOperation.this.results.put(this.did, new PayoutResult.DispenseResult(PayoutResult.ResultType.Ambiguity, null));
            CascadeOperation.this.finish();
        }
    }
}

