/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.utils;

import ru.softlogic.hdw.ByteHolder;

public final class ByteUtil {
    public static final int DEFAULT_LINESIZE = 32;

    private ByteUtil() {
    }

    public static String toString(byte ... data) {
        if (data == null) {
            return "";
        }
        return ByteUtil.toString(data, 0, data.length, 32);
    }

    public static String toString(byte[] data, int lineSize) {
        if (data == null) {
            return "";
        }
        return ByteUtil.toString(data, 0, data.length, lineSize);
    }

    public static String toString(byte[] data, int offset, int len) {
        return ByteUtil.toString(data, offset, len, 32);
    }

    public static String toString(byte[] data, int offset, int len, int lineSize) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (sb.length() > 0) {
                sb.append(i % 16 == 0 ? (char)'|' : ' ');
            }
            if (i > 0 && i % lineSize == 0) {
                sb.append('\n');
            }
            sb.append(String.format("%02x", data[offset + i]));
        }
        return sb.toString();
    }

    public static String toString(byte[] ... data) {
        if (data == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int total = 0;
        for (byte[] arr : data) {
            for (int i = 0; i < arr.length; ++i) {
                if (total > 0 && total % 32 == 0) {
                    sb.append('\n');
                } else if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(String.format("%02x", arr[i]));
                ++total;
            }
        }
        return sb.toString();
    }

    public static boolean startWith(byte[] data, byte ... prefix) {
        if (data == null || data.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (data[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] union(byte[] ... data) {
        int len = 0;
        for (byte[] d : data) {
            len += d.length;
        }
        byte[] res = new byte[len];
        int start = 0;
        for (byte[] d : data) {
            System.arraycopy(d, 0, res, start, d.length);
            start += d.length;
        }
        return res;
    }

    public static ByteHolder getByteHolder(byte[] req, int offset, int length) {
        return new ByteHolder(ByteUtil.getPiece(req, offset, length));
    }

    public static byte[] getPiece(byte[] req, int offset) {
        return ByteUtil.getPiece(req, offset, req.length - offset);
    }

    public static byte[] getPiece(byte[] req, int offset, int length) {
        byte[] res = new byte[length];
        System.arraycopy(req, offset, res, 0, length);
        return res;
    }

    public static int convert(byte data) {
        return data & 0xFF;
    }

    public static byte convert(int data) {
        return (byte)(data & 0xFF);
    }

    public static int getInt(byte[] data, int start, int length, ByteOrder byteOrder) {
        ByteUtil.checkLen(length, 1, 4);
        int res = 0;
        for (int i = 0; i < length; ++i) {
            res = (res << 8) + (data[ByteUtil.getIndex(start, length, i, byteOrder)] & 0xFF);
        }
        return res;
    }

    public static long getLong(byte[] data, int start, int length, ByteOrder byteOrder) {
        ByteUtil.checkLen(length, 1, 8);
        long res = 0L;
        for (int i = 0; i < length; ++i) {
            res = (res << 8) + (long)(data[ByteUtil.getIndex(start, length, i, byteOrder)] & 0xFF);
        }
        return res;
    }

    public static void store(byte[] src, byte[] dst, int offset) {
        System.arraycopy(src, 0, dst, offset, src.length);
    }

    private static void store(long data, int len, byte[] dest, int offset, ByteOrder byteOrder) {
        for (int i = 0; i < len; ++i) {
            dest[ByteUtil.getIndex((int)offset, (int)len, (int)i, (ByteOrder)byteOrder)] = (byte)(data & 0xFFL);
            data >>= 8;
        }
    }

    private static void checkLen(int length, int min, int max) {
        if (length < min || length > max) {
            throw new IllegalArgumentException("Length must be in range " + min + ".." + max);
        }
    }

    private static int getIndex(int start, int length, int i, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BigEndian) {
            return start + i;
        }
        return start + length - i - 1;
    }

    public static byte[] convert(String data) {
        String pData = data.replaceAll(" |\n", "");
        byte[] res = new byte[pData.length() / 2];
        for (int i = 0; i < pData.length() / 2; ++i) {
            res[i] = (byte)Integer.parseInt(pData.substring(i * 2, i * 2 + 2), 16);
        }
        return res;
    }

    public static final class LittleEndian {
        private LittleEndian() {
        }

        public static int getInt(byte[] data, int start, int length) {
            return ByteUtil.getInt(data, start, length, ByteOrder.LittleEndian);
        }

        public static long getLong(byte[] data, int start, int length) {
            return ByteUtil.getLong(data, start, length, ByteOrder.LittleEndian);
        }

        public static void store(long data, int len, byte[] dest, int offset) {
            ByteUtil.store(data, len, dest, offset, ByteOrder.BigEndian);
        }
    }

    public static final class BigEndian {
        private BigEndian() {
        }

        public static int getInt(byte[] data, int start, int length) {
            return ByteUtil.getInt(data, start, length, ByteOrder.BigEndian);
        }

        public static long getLong(byte[] data, int start, int length) {
            return ByteUtil.getLong(data, start, length, ByteOrder.BigEndian);
        }

        public static void store(long data, int len, byte[] dest, int offset) {
            ByteUtil.store(data, len, dest, offset, ByteOrder.LittleEndian);
        }
    }

    public static final class Ascii {
        private Ascii() {
        }

        public static boolean isDigitString(byte[] data, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                byte b = data[offset + i];
                if (b >= 48 && b <= 57) continue;
                return false;
            }
            return true;
        }

        public static boolean isDigitString(byte[] data) {
            return Ascii.isDigitString(data, 0, data.length);
        }
    }

    public static enum ByteOrder {
        BigEndian,
        LittleEndian;

    }
}

