/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.handling;

import java.util.ResourceBundle;
import ru.softlogic.hdw.handling.DeviceState;

public class HdwMsg {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(HdwMsg.class.getPackage().getName() + ".messages");

    public static String get(String key) {
        try {
            return BUNDLE.getString(key);
        }
        catch (Exception ex) {
            return key;
        }
    }

    public static String getState(DeviceState state) {
        if (state == null) {
            return null;
        }
        String stateString = HdwMsg.getState(state.getDeviceClass(), state.getState());
        String flags = HdwMsg.getFlags(state.getDeviceClass(), state.getFlags());
        return stateString + "[" + flags + "]";
    }

    public static String getState(int deviceClass, int state) {
        String devClass = state <= 0 ? "" : deviceClass + ".";
        return HdwMsg.get("state." + devClass + state);
    }

    public static String getStateTitle(int deviceClass, int state) {
        String devClass = state <= 0 ? "" : deviceClass + ".";
        return HdwMsg.get("state.title." + devClass + state);
    }

    public static String getFraudMarker(int markerId) {
        return HdwMsg.get("fraud." + markerId);
    }

    public static String getBvrEvent(int eventId) {
        return HdwMsg.get("bvr.event." + eventId);
    }

    public static String getFlags(int deviceClass, int flags) {
        if (flags == 0) {
            return "OK";
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append(HdwMsg.getFlag(deviceClass, flag));
        }
        return res.toString();
    }

    public static String getFlag(int deviceClass, int flag) {
        String key = "flag." + deviceClass + "." + String.format("0x%04x", flag);
        return HdwMsg.get(key);
    }

    public static String getFlagsTitle(int deviceClass, int flags) {
        if (flags == 0) {
            return "OK";
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int flag = 1 << i;
            if ((flags & flag) <= 0) continue;
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append(HdwMsg.getFlagTitle(deviceClass, flag));
        }
        return res.toString();
    }

    public static String getFlagTitle(int deviceClass, int flag) {
        String key = "flag.title." + deviceClass + "." + String.format("0x%04x", flag);
        return HdwMsg.get(key);
    }

    public static String getSensor(int sensorType) {
        return HdwMsg.get("sensor." + sensorType);
    }

    public static String getSensorEvent(int sensorType, int eventId) {
        return HdwMsg.get("sensor.event." + sensorType + "." + eventId);
    }
}

