/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.webcam;

import java.awt.Dimension;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.softlogic.config.ParceException;
import ru.softlogic.config.SerialDeviceSection;
import ru.softlogic.hdw.dev.webcam.WcmConfiguration;
import ru.softlogic.hdw.dev.webcam.WcmOptions;
import ru.softlogic.io.serial.SerialPort;

public class WcmSection
extends SerialDeviceSection {
    public static final String RESOLUTION = "resolution";
    public static final String ALWAYS_OPEN = "always-open";
    private WcmConfiguration wcm;

    public WcmSection() {
    }

    public WcmSection(WcmConfiguration wcm) {
        this.wcm = wcm;
    }

    @Override
    public String getKey() {
        return "webcam";
    }

    @Override
    public void parce(Element element) throws ParceException {
        boolean enable = this.getEnable(element);
        String type = this.getDriver(element);
        SerialPort port = this.getSerialPort(element);
        Map<String, String> opt = this.readOptions(element);
        String resolution = this.readString(opt, RESOLUTION, "640x480");
        String alwaysOpen = this.readString(opt, ALWAYS_OPEN, "false");
        try {
            int width = Integer.parseInt(resolution.split("x")[0]);
            int height = Integer.parseInt(resolution.split("x")[1]);
            this.wcm = new WcmConfiguration(enable, type, port, new WcmOptions(new Dimension(width, height), Boolean.parseBoolean(alwaysOpen)));
        }
        catch (NumberFormatException e) {
            throw new ParceException(e);
        }
    }

    @Override
    public Element generate(Document doc) {
        return this.generate(doc, this.wcm);
    }

    @Override
    public void generateOptions(Document doc, Element root) {
        WcmOptions wo = this.wcm.getOptions();
        if (wo != null && wo.getResolution() != null) {
            this.writeOption(doc, root, RESOLUTION, (int)wo.getResolution().getWidth() + "x" + (int)wo.getResolution().getHeight());
        }
        if (wo != null && wo.isAlwaysOpen()) {
            this.writeOption(doc, root, ALWAYS_OPEN, "true");
        }
    }

    public WcmConfiguration getConfiguration() {
        return this.wcm;
    }
}

