/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.webcam;

import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.webcam.WcmOptions;
import ru.softlogic.hdw.dev.webcam.Webcam;
import ru.softlogic.hdw.dev.webcam.WebcamDriver;
import ru.softlogic.hdw.dev.webcam.WebcamListener;
import ru.softlogic.hdw.dev.webcam.WebcamMotionListener;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public abstract class BaseWebcamDriver
extends BaseDevice
implements WebcamDriver,
Webcam,
Runnable {
    private static final String BASE_VERSION = "1.0.0";
    private final SerialPort port;
    private final Logger log;
    private final WcmOptions options;
    protected final List<Thread> threads = new LinkedList<Thread>();
    private WebcamListener listener;
    private final Set<WebcamMotionListener> motionListeners = new HashSet<WebcamMotionListener>();

    public BaseWebcamDriver(String type, SerialPort port, WcmOptions options, Logger log) {
        super(new DeviceId(23, type, 0), BASE_VERSION, log);
        this.port = port;
        this.log = log;
        this.options = options;
        this.threads.add(new Thread((Runnable)this, "drv(" + type + ")"));
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public Webcam getWebcam() {
        return this;
    }

    protected void notifyPhoto(BufferedImage photo) {
        if (photo == null) {
            this.log.error((Object)"Photo is null");
            return;
        }
        if (this.listener != null) {
            this.listener.onPhoto(photo);
        }
    }

    protected void notifyError() {
        this.log.info((Object)"Notify error");
        if (this.listener != null) {
            this.listener.onError();
        }
    }

    protected void notifyMotion() {
        this.log.info((Object)"Notify motion");
        for (WebcamMotionListener wml : this.motionListeners) {
            wml.onMotion();
        }
    }

    @Override
    public void addWebcamMotionListener(WebcamMotionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.motionListeners.add(listener);
    }

    @Override
    public void removeWebcamMotionListener(WebcamMotionListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.motionListeners.remove(listener);
    }

    @Override
    public void setWebcamListener(WebcamListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is null");
        }
        this.listener = listener;
    }

    protected DeviceInfo createDeviceInfo() {
        DeviceId did = this.getDeviceId();
        DeviceInfo di = new DeviceInfo(did.getDeviceClass(), did.getType());
        di.setPort(SerialFmt.format((SerialPort)this.port));
        return di;
    }
}

