/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.watchdog;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.watchdog.WatchDog;
import ru.softlogic.hdw.dev.watchdog.WatchDogDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public abstract class BaseWatchDogDriver
extends BaseDevice
implements WatchDogDriver,
WatchDog,
Runnable {
    private static final String BASE_VERSION = "c2.0.0";
    private final List<Thread> threads;
    private final SerialPort port;
    private final Logger log;
    private final BlockingQueue<Integer> operations = new LinkedBlockingDeque<Integer>();

    public BaseWatchDogDriver(String type, SerialPort port, Logger log) {
        super(new DeviceId(5, type, 0), BASE_VERSION, log);
        this.port = port;
        this.log = log;
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + type + ")"));
    }

    @Override
    public WatchDog getWatchDog() {
        return this;
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public void resetModem() {
        this.operations.add(0);
        this.notifySleep();
    }

    @Override
    public void run() {
        this.log.info((Object)"Start watchdog driver");
        this.log.info((Object)("Port: " + SerialFmt.format((SerialPort)this.port)));
        DeviceId deviceId = this.getDeviceId();
        this.log.info((Object)("Driver: " + deviceId.getType() + ", number: " + deviceId.getNumber()));
        this.updateDeviceInfo(this.createDeviceInfo());
        this.updateState(0);
        boolean inited = false;
        try {
            int i = 0;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (!inited) {
                        this.openDevice();
                        inited = true;
                    }
                    if (this.operations.poll(5L, TimeUnit.SECONDS) != null) {
                        this.rebootModem();
                    } else {
                        this.pingDevice();
                    }
                    if (++i == 100) {
                        this.log.info((Object)"State done");
                        i = 0;
                    }
                    this.onConnSuccess();
                }
                catch (IOException ex) {
                    this.onConnError(ex);
                    this.closeDevice();
                    this.sleep(1000);
                    inited = false;
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop device");
        this.stopDevice();
        this.log.info((Object)"Done");
        this.port.close();
        this.log.info((Object)"Stop thread");
    }

    protected DeviceInfo createDeviceInfo() {
        DeviceId deviceId = this.getDeviceId();
        DeviceInfo di = new DeviceInfo(deviceId.getDeviceClass(), deviceId.getType());
        di.setPort(SerialFmt.format((SerialPort)this.port));
        return di;
    }

    protected abstract void openDevice() throws IOException;

    protected abstract void closeDevice();

    protected abstract void rebootModem() throws IOException, InterruptedException;

    protected abstract void pingDevice() throws IOException, InterruptedException;

    protected void stopDevice() {
    }
}

