/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.sensors;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.sensors.SensorDescriptor;
import ru.softlogic.hdw.dev.sensors.SensorDriver;
import ru.softlogic.hdw.dev.sensors.SensorOptions;
import ru.softlogic.io.Port;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.usb.UsbPort;

public class SensorFactory
extends BaseFactory {
    public static SensorDriver createDriver(String type, Port port, SensorOptions options, Logger log) throws CreatingException {
        SensorFactory.check(type, port, log);
        if (options == null) {
            throw new CreatingException("Options is not set");
        }
        try {
            switch (port.getType()) {
                case SerialPort: {
                    return SensorFactory.createSerialDriver(type, (SerialPort)port, options, log);
                }
                case UsbPort: {
                    return SensorFactory.createUsbDriver(type, (UsbPort)port, options, log);
                }
            }
            return SensorFactory.createLptDriver(type, (ParallelPort)port, options, log);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }

    public static SensorDescriptor createDescriptor(String type) throws CreatingException {
        return new SensorDescriptor(SensorFactory.getFeaturesQuetly("snr", type));
    }

    private static SensorDriver createSerialDriver(String type, SerialPort port, SensorOptions options, Logger log) throws Exception {
        String pkg = "ru.softlogic.hardware.snr." + type.toLowerCase() + ".driver.Driver";
        Class<?> cl = Class.forName(pkg);
        return (SensorDriver)cl.getConstructor(SerialPort.class, SensorOptions.class, Logger.class).newInstance(port, options, log);
    }

    private static SensorDriver createUsbDriver(String type, UsbPort port, SensorOptions options, Logger log) throws Exception {
        String pkg = "ru.softlogic.hardware.snr." + type.toLowerCase() + ".driver.Driver";
        Class<?> cl = Class.forName(pkg);
        return (SensorDriver)cl.getConstructor(UsbPort.class, SensorOptions.class, Logger.class).newInstance(port, options, log);
    }

    private static SensorDriver createLptDriver(String type, ParallelPort port, SensorOptions options, Logger log) throws Exception {
        String pkg = "ru.softlogic.hardware.snr." + type.toLowerCase() + ".driver.Driver";
        Class<?> cl = Class.forName(pkg);
        return (SensorDriver)cl.getConstructor(ParallelPort.class, SensorOptions.class, Logger.class).newInstance(port, options, log);
    }
}

