/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.sensors;

import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.handling.HdwMsg;

public class SensorEvent {
    private final short deviceClass;
    private final int type;
    private final int id;
    private final int value;

    public SensorEvent(short deviceClass, int type, int id, int value) {
        this.deviceClass = deviceClass;
        this.type = type;
        this.id = id;
        this.value = value;
    }

    public SensorEvent(Sensor snr, int value) {
        this.deviceClass = snr.getDeviceClass();
        this.type = snr.getType();
        this.id = snr.getId();
        this.value = value;
    }

    public short getDeviceClass() {
        return this.deviceClass;
    }

    public int getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return HdwMsg.getSensor(this.type) + " #" + this.id + ": " + HdwMsg.getSensorEvent(this.type, this.value);
    }
}

