/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.spooler;

import java.io.IOException;
import ru.softlogic.hdw.dev.printer.PrintException;
import ru.softlogic.hdw.dev.printer.PrintModule;
import ru.softlogic.hdw.dev.printer.spooler.JobStateListener;
import ru.softlogic.hdw.dev.printer.spooler.PrinterJob;

public abstract class BasePrinterJob
implements PrinterJob {
    private JobStateListener jobStateListener;

    public BasePrinterJob() {
    }

    public BasePrinterJob(JobStateListener jobStateListener) {
        this.jobStateListener = jobStateListener;
    }

    @Override
    public void print(PrintModule printer) {
        try {
            this.notifyState(1);
            this._print(printer);
            this.notifyState(2);
        }
        catch (PrintException ex) {
            this.notifyState(3);
        }
        catch (IOException ex) {
            this.notifyState(3);
        }
    }

    abstract void _print(PrintModule var1) throws PrintException, IOException;

    private void notifyState(int state) {
        if (this.jobStateListener != null) {
            this.jobStateListener.onState(state);
        }
    }
}

