/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.pblock;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.PrnUtils;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterApi;
import ru.softlogic.hdw.dev.printer.pos.pblock.PrintBlock;

public class ImagePrintBlock
implements PrintBlock {
    private final String name;
    private final int size;
    private final Logger log;

    public ImagePrintBlock(String name, int size, Logger log) {
        this.name = name;
        this.size = size;
        this.log = log;
    }

    @Override
    public void print(PosPrinterApi api) throws IOException {
        if (api.getImageApi() != null) {
            try {
                api.getImageApi().printImage(PrnUtils.getLogoPath(this.name), this.size);
            }
            catch (Exception ex) {
                this.log.error((Object)"Error on print image", (Throwable)ex);
            }
        }
    }

    public String toString() {
        return "ImagePrintBlock{name=" + this.name + ", size=" + this.size + '}';
    }
}

