/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.pblock;

import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.PrnUtils;
import ru.softlogic.hdw.dev.printer.pos.BarcodeApi;
import ru.softlogic.hdw.dev.printer.pos.ImageApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterApi;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeException;
import ru.softlogic.hdw.dev.printer.pos.img.BarcodeGenerator;
import ru.softlogic.hdw.dev.printer.pos.pblock.PrintBlock;

public class BarcodePrintBlock
implements PrintBlock {
    public static final int SIZE_NORMAL = 0;
    public static final int SIZE_DOUBLE_WIDTH = 1;
    public static final int SIZE_DOUBLE_HEIGHT = 2;
    public static final int SIZE_DOUBLE = 3;
    public static final String TYPE_QRCODE = "qrcode";
    public static final String TYPE_PDF417 = "pdf417";
    public static final String TYPE_DATA_MATRIX = "dm";
    private static final String NAME = "barcodesrc.png";
    private final String value;
    private final String type;
    private final Map<String, String> params;
    private final int size;
    private final Logger log;

    public BarcodePrintBlock(String type, String value, int size, Map<String, String> params, Logger log) {
        this.size = size;
        this.value = value;
        this.type = type;
        this.params = params;
        this.log = log;
    }

    @Override
    public void print(PosPrinterApi api) throws IOException, InterruptedException {
        BarcodeApi bapi = api.getBarcodeApi();
        if (bapi != null && (bapi.getSupportedTypes() & this.getTypeByStr(this.type)) != 0) {
            bapi.printBarocode(this.value);
        } else {
            ImageApi ia = api.getImageApi();
            if (ia != null) {
                try {
                    if (TYPE_PDF417.equals(this.type)) {
                        BarcodeGenerator.generatePDF417(PrnUtils.getBarcodePath(NAME), this.value, this.params);
                    } else if (TYPE_QRCODE.equals(this.type)) {
                        BarcodeGenerator.generateQRCode(PrnUtils.getBarcodePath(NAME), this.value, this.params);
                    } else if (TYPE_DATA_MATRIX.equals(this.type)) {
                        BarcodeGenerator.generateDataMatrix(PrnUtils.getBarcodePath(NAME), this.value, this.params);
                    } else {
                        throw new BarcodeException("Wrong barcode type: " + this.type);
                    }
                    ia.printImage(PrnUtils.getBarcodePath(NAME), this.size);
                }
                catch (WrongImageException ex) {
                    this.log.error((Object)"Error on process image", (Throwable)ex);
                }
                catch (BarcodeException ex) {
                    this.log.error((Object)"Error on process image", (Throwable)ex);
                }
            }
        }
    }

    public String toString() {
        return "BarcodePrintBlock{value=" + this.value + ", type=" + this.type + ", name=" + NAME + ", size=" + this.size + '}';
    }

    private int getTypeByStr(String type) {
        if (TYPE_PDF417.equals(type)) {
            return 2;
        }
        if (TYPE_QRCODE.equals(type)) {
            return 1;
        }
        if (TYPE_DATA_MATRIX.equals(type)) {
            return 4;
        }
        return 0;
    }
}

