/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos.fonts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import ru.softlogic.hdw.dev.printer.PrinterFactory;
import ru.softlogic.hdw.dev.printer.pos.LoadFontApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterApi;
import ru.softlogic.hdw.dev.printer.pos.PosPrinterDescriptor;
import ru.softlogic.hdw.dev.printer.pos.PosPrtOptions;
import ru.softlogic.hdw.dev.printer.pos.fonts.CharacterBitmapEntry;
import ru.softlogic.hdw.dev.printer.pos.fonts.FontDescriptor;
import ru.softlogic.hdw.utils.BundleHelper;
import ru.softlogic.io.utils.BU;

public class FontProcessor {
    private static final int MAX_SYMBOLS_COUNT = 95;
    private static final String TAG_CUSTOM_FONT_ON = "<custom-font>";
    private static final String TAG_CUSTOM_FONT_OFF = "</custom-font>";
    private static Map<Character, CharacterBitmapEntry> bitmapMap;
    private static FontDescriptor currentFont;
    private static int curSymbolNumber;

    private FontProcessor() {
    }

    private static byte[] getSymbolBitmap(ResourceBundle bundle, char character) {
        try {
            String string = bundle.getString(Character.toString(character));
            return BU.convertFromHex((String)string);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static ResourceBundle getBundle(String printerName, FontDescriptor fontDescription) {
        String fileName = fontDescription.getWidth() + "x" + fontDescription.getHight();
        ResourceBundle bundle = BundleHelper.getBundle("ru.softlogic.hardware.pos." + printerName + "." + fileName);
        if (bundle != null) {
            return bundle;
        }
        return BundleHelper.getBundle(FontProcessor.class.getPackage().getName() + "." + fileName);
    }

    private static synchronized Map<Character, CharacterBitmapEntry> getAllSymbolBitmap(String printerName, FontDescriptor fontDescription) {
        if (bitmapMap != null) {
            return bitmapMap;
        }
        ResourceBundle bundle = FontProcessor.getBundle(printerName, fontDescription);
        if (bundle == null) {
            return null;
        }
        HashMap<Character, CharacterBitmapEntry> map = new HashMap<Character, CharacterBitmapEntry>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            char key = keys.nextElement().charAt(0);
            byte[] symbolBitmap = FontProcessor.getSymbolBitmap(bundle, key);
            if (symbolBitmap == null) continue;
            map.put(Character.valueOf(key), new CharacterBitmapEntry(symbolBitmap));
        }
        bitmapMap = map;
        return map;
    }

    public static String process(PosPrinterApi printerApi, PosPrtOptions options, String printerName, String data) throws IOException {
        if (!options.isUseCustomFont() || printerApi.getLoadFontApi() == null) {
            return data;
        }
        FontDescriptor fontPropName = FontProcessor.getFontSize(printerName, options.getFont());
        if (fontPropName == null) {
            return data;
        }
        Map<Character, CharacterBitmapEntry> allSymbolBitmap = FontProcessor.getAllSymbolBitmap(printerName, fontPropName);
        if (allSymbolBitmap == null) {
            return data;
        }
        ArrayList<CharacterBitmapEntry> needLoad = new ArrayList<CharacterBitmapEntry>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char charAt = data.charAt(i);
            if (charAt < '\u007f') {
                sb.append(charAt);
                continue;
            }
            CharacterBitmapEntry entry = allSymbolBitmap.get(Character.valueOf(charAt));
            if (entry != null) {
                char alternativeCode = (char)(32 + (curSymbolNumber + 1) % 95);
                if (curSymbolNumber + 1 > 95) {
                    for (CharacterBitmapEntry e : allSymbolBitmap.values()) {
                        if (e.getAlias() != alternativeCode) continue;
                        e.setAlias((byte)0);
                        break;
                    }
                }
                if (!entry.isLoad()) {
                    entry.setAlias((byte)alternativeCode);
                    needLoad.add(entry);
                    ++curSymbolNumber;
                }
                sb.append(TAG_CUSTOM_FONT_ON);
                sb.append(entry.getAliasAsString());
                sb.append(TAG_CUSTOM_FONT_OFF);
                continue;
            }
            sb.append(charAt);
        }
        for (CharacterBitmapEntry entry : needLoad) {
            LoadFontApi fontApi = printerApi.getLoadFontApi();
            fontApi.load(fontPropName.getWidth(), fontPropName.getHight(), entry.getAlias(), entry.getBitMap());
        }
        return sb.toString();
    }

    public static synchronized FontDescriptor getFontSize(String printerName, int fontType) {
        if (currentFont == null) {
            try {
                PosPrinterDescriptor desc = PrinterFactory.createPosDescriptor(printerName);
                currentFont = fontType == 2 ? desc.getFontB() : desc.getFontA();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currentFont;
    }

    static {
        curSymbolNumber = 0;
    }
}

