/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos;

public class PosPrtOptions {
    public static final int FONT_DEFAULT = 0;
    public static final int FONT_A = 1;
    public static final int FONT_B = 2;
    public static final int SPACING_DEFAULT = 0;
    public static final int SPACING_SMALL = 1;
    public static final int SPACING_BIG = 2;
    private final int leftMargin;
    private final int width;
    private final int scroll;
    private final int font;
    private final int spacing;
    private final int eject;
    private final boolean usePneSensor;
    private final String encode;
    private final boolean useCustomFont;

    public PosPrtOptions(int leftMargin, int width, int scroll, int font, int spacing, int eject, boolean usePneSensor, String encode, boolean useCustomFont) {
        if (leftMargin < 0) {
            throw new IllegalArgumentException("Left margin must be positive");
        }
        if (width < 0) {
            throw new IllegalArgumentException("Width must be positive");
        }
        if (scroll < 0) {
            throw new IllegalArgumentException("Scroll must be positive");
        }
        if (spacing < 0) {
            throw new IllegalArgumentException("Spacing must be positive");
        }
        if (eject < 0) {
            throw new IllegalArgumentException("Eject must be positive");
        }
        if (encode == null) {
            throw new NullPointerException("Encode is not set");
        }
        this.leftMargin = leftMargin;
        this.width = width;
        this.scroll = scroll;
        this.font = font;
        this.spacing = spacing;
        this.eject = eject;
        this.usePneSensor = usePneSensor;
        this.encode = encode;
        this.useCustomFont = useCustomFont;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getWidth() {
        return this.width;
    }

    public int getScroll() {
        return this.scroll;
    }

    public int getFont() {
        return this.font;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public int getEject() {
        return this.eject;
    }

    public boolean isUsePneSensor() {
        return this.usePneSensor;
    }

    public String getEncode() {
        return this.encode;
    }

    public boolean isUseCustomFont() {
        return this.useCustomFont;
    }

    public String toString() {
        return "PosPrtOptions{leftMargin=" + this.leftMargin + ", width=" + this.width + ", scroll=" + this.scroll + ", font=" + this.font + ", spacing=" + this.spacing + ", eject=" + this.eject + ", usePneSensor=" + this.usePneSensor + ", encode=" + this.encode + '}';
    }
}

