/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import ru.softlogic.hdw.utils.BundleHelper;

public class PosPrinterUtils {
    private static Map<Character, Character> replaces;
    private static Set<String> encodings;
    private static String encoding;

    public static synchronized Set<String> getEncodings() {
        if (encodings == null) {
            TreeSet<String> res = new TreeSet<String>();
            res.add(PosPrinterUtils.getDefaultEncoding());
            String encs = System.getProperty("printer.encodings");
            if (encs != null) {
                for (String enc : encs.split(",")) {
                    enc = PosPrinterUtils.normalize(enc);
                    if (!PosPrinterUtils.isValid(encs)) continue;
                    res.add(enc);
                }
            }
            encodings = Collections.unmodifiableSet(res);
        }
        return encodings;
    }

    public static synchronized String getDefaultEncoding() {
        if (encoding == null) {
            String enc = PosPrinterUtils.normalize(System.getProperty("printer.encoding"));
            encoding = PosPrinterUtils.isValid(enc) ? enc : "866";
        }
        return encoding;
    }

    public static synchronized Map<Character, Character> getReplaceMap() {
        if (replaces == null) {
            String path;
            ResourceBundle bundle;
            String useReplace;
            HashMap<Character, Character> res = new HashMap<Character, Character>();
            String repl = System.getProperty("printer.replaces");
            if (repl != null) {
                for (String str : repl.split(",")) {
                    if (str.length() != 2) continue;
                    res.put(Character.valueOf(str.charAt(0)), Character.valueOf(str.charAt(1)));
                }
            }
            if (Boolean.parseBoolean(useReplace = System.getProperty("printer.replaces.internal")) && (bundle = BundleHelper.getBundle(path = PosPrinterUtils.class.getPackage().getName() + ".fonts.replace")) != null) {
                for (String key : bundle.keySet()) {
                    String alternative = bundle.getString(key);
                    if (alternative.isEmpty()) continue;
                    res.put(Character.valueOf(key.charAt(0)), Character.valueOf(alternative.charAt(0)));
                }
            }
            replaces = Collections.unmodifiableMap(res);
        }
        return replaces;
    }

    private static boolean isValid(String enc) {
        if (enc == null || enc.isEmpty()) {
            return false;
        }
        try {
            Charset.forName(enc);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    private static String normalize(String encoding) {
        return encoding == null ? null : encoding.trim();
    }
}

