/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos;

import ru.softlogic.hdw.dev.printer.pos.fonts.FontDescriptor;

public class PosPrinterDescriptor {
    public static final int FEATURE_SERIAL_SUPPORT = 1;
    public static final int FEATURE_USB_SUPPORT = 2;
    public static final int FEATURE_PARALLEL_SUPPORT = 4;
    private final int features;
    private final int defWidth;
    private final int minWidth;
    private final int maxWidth;
    private final int defLeftMargin;
    private final int defScroll;
    private final FontDescriptor fontA;
    private final FontDescriptor fontB;

    public PosPrinterDescriptor(int features, int minWidth, int maxWidth, int defWidth, int defLeftMargin, int defScroll, FontDescriptor fontA, FontDescriptor fontB) {
        this.features = features;
        this.defWidth = defWidth;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.defLeftMargin = defLeftMargin;
        this.defScroll = defScroll;
        this.fontA = fontA;
        this.fontB = fontB;
    }

    public int getFeatures() {
        return this.features;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getDefWidth() {
        return this.defWidth;
    }

    public int getDefLeftMargin() {
        return this.defLeftMargin;
    }

    public int getDefScroll() {
        return this.defScroll;
    }

    public final boolean isFeatureSupport(int feature) {
        return (this.getFeatures() & feature) != 0;
    }

    public FontDescriptor getFontA() {
        return this.fontA;
    }

    public FontDescriptor getFontB() {
        return this.fontB;
    }

    public String toString() {
        return "PosPrinterDescriptor{features=" + this.features + ", defWidth=" + this.defWidth + ", minWidth=" + this.minWidth + ", maxWidth=" + this.maxWidth + ", defLeftMargin=" + this.defLeftMargin + ", defScroll=" + this.defScroll + ", fontA=" + this.fontA + ", fontB=" + this.fontB + '}';
    }
}

