/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.pos;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.printer.pos.WrongImageException;
import ru.softlogic.hdw.dev.printer.pos.img.ImageReader;
import ru.softlogic.hdw.dev.printer.pos.img.PrnImage;
import ru.softlogic.io.Port;
import ru.softlogic.io.utils.BU;

public final class EscPosUtils {
    protected static final int IMG_TIMEOUT = 50;
    protected static final int IMG_SIZE = 500;

    private EscPosUtils() {
    }

    public static void printImageAlg2(Port port, File path, int size, Logger log) throws IOException, WrongImageException, InterruptedException {
        PrnImage image = ImageReader.readImage1b2a24dot(path);
        log.info((Object)("Loaded image, resolution: " + image.getWidth() + "x" + image.getHeight()));
        byte[] hdr = new byte[]{27, 42, 33, BU.c((int)(image.getWidth() % 256)), BU.c((int)(image.getWidth() / 256))};
        byte[] buf = new byte[image.getWidth()];
        port.write(new byte[]{27, 51, 0, 10});
        for (int i = 0; i < image.getHeight() / 24; ++i) {
            port.write(hdr);
            for (int j = 0; j < 3; ++j) {
                System.arraycopy(image.getData(), (3 * i + j) * buf.length, buf, 0, buf.length);
                port.write(buf);
                Thread.sleep(50L);
            }
            port.write((byte)10);
        }
        port.write(new byte[]{27, 50});
        log.info((Object)"Ready!");
    }

    public static void printImageAlg1(Port port, File path, int size, Logger log) throws IOException, WrongImageException, InterruptedException {
        log.info((Object)("Read image: " + path));
        PrnImage image = ImageReader.getImageH(path);
        log.info((Object)("Done, size: " + image.getWidth() + "x" + image.getHeight()));
        long start = System.currentTimeMillis();
        port.write(new byte[]{29, 118, 48, (byte)size, (byte)(image.getWidth() / 8 % 256), (byte)(image.getWidth() / 8 / 256), (byte)(image.getHeight() % 256), (byte)(image.getHeight() / 256)});
        int step = 500;
        int count = image.getData().length / step;
        byte[] buf = new byte[step];
        for (int i = 0; i < count; ++i) {
            log.info((Object)("Load piece " + i + " of " + count));
            System.arraycopy(image.getData(), i * step, buf, 0, step);
            port.write(buf);
            Thread.sleep(50L);
        }
        if (image.getData().length % step != 0) {
            log.info((Object)"Load rest");
            buf = new byte[image.getData().length % step];
            System.arraycopy(image.getData(), image.getData().length - buf.length, buf, 0, buf.length);
            port.write(buf);
        }
        log.info((Object)("Ready, timeout: " + (System.currentTimeMillis() - start)));
    }

    public static void loadImage(Port port, File path, Logger log) throws WrongImageException, IOException, InterruptedException {
        PrnImage image = ImageReader.getImage(path);
        log.info((Object)("Loaded image, resolution: " + image.getWidth() + "x" + image.getHeight()));
        log.info((Object)"Try load it to printer");
        port.write(new byte[]{29, 42, BU.c((int)(image.getWidth() / 8)), BU.c((int)(image.getHeight() / 8))});
        int step = 500;
        int count = image.getData().length / step;
        byte[] buf = new byte[step];
        log.info((Object)("Step size: " + step + ", total steps: " + count));
        for (int i = 0; i < count; ++i) {
            log.info((Object)("Load piece " + i + " of " + count));
            System.arraycopy(image.getData(), i * step, buf, 0, step);
            port.write(buf);
            Thread.sleep(50L);
        }
        if (image.getData().length % step != 0) {
            log.info((Object)"Load rest");
            buf = new byte[image.getData().length % step];
            System.arraycopy(image.getData(), image.getData().length - buf.length, buf, 0, buf.length);
            port.write(buf);
        }
        log.info((Object)"Ready!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBmpImage(Port port, File path, int bankNo, Logger log) throws IOException, InterruptedException {
        BufferedImage src = ImageIO.read(path);
        if (src.getWidth() < 620 && src.getHeight() < 400) {
            BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), 12);
            ByteArrayOutputStream baos = null;
            try {
                Graphics2D g = dst.createGraphics();
                g.drawImage((Image)src, 0, 0, null);
                g.dispose();
                baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)dst, "BMP", baos);
                if (baos.size() <= 32768) {
                    byte[] res = baos.toByteArray();
                    res[57] = 0;
                    res[61] = 0;
                    port.write(new byte[]{29, 42, BU.c((int)bankNo)});
                    int step = 500;
                    int count = res.length / step;
                    byte[] buf = new byte[step];
                    log.info((Object)("Step size: " + step + ", total steps: " + count));
                    for (int i = 0; i < count; ++i) {
                        log.info((Object)("Load piece " + i + " of " + count));
                        System.arraycopy(res, i * step, buf, 0, step);
                        port.write(buf);
                        Thread.sleep(50L);
                    }
                    if (res.length % step != 0) {
                        log.info((Object)"Load rest");
                        buf = new byte[res.length % step];
                        System.arraycopy(res, res.length - buf.length, buf, 0, buf.length);
                        port.write(buf);
                    }
                    log.info((Object)"Load done!");
                }
                log.error((Object)("Can't print image. Wrong size: " + baos.size() + ". Max image size 32768"));
            }
            finally {
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            log.error((Object)("Can't print image. Wrong resolution: " + src.getWidth() + "x" + src.getHeight() + ". Max resolution 620x400"));
        }
    }

    public static void printQR(Port port, String data) throws IOException {
        EscPosUtils.sendQRCmd(port, 49, 65, 0);
        EscPosUtils.sendQRCmd(port, 49, 66, 6);
        EscPosUtils.sendQRCmd(port, 49, 67, 5);
        EscPosUtils.sendQRCmd(port, 49, 69, 1);
        EscPosUtils.sendQRCmd(port, 49, 80, 49, data.getBytes());
        EscPosUtils.sendQRCmd(port, 49, 81, 49);
    }

    private static void sendQRCmd(Port port, int cn, int fn, int m) throws IOException {
        EscPosUtils.sendQRCmd(port, cn, fn, m, null);
    }

    private static void sendQRCmd(Port port, int cn, int fn, int m, byte[] data) throws IOException {
        byte[] cmd = new byte[8 + (data != null ? data.length : 0)];
        cmd[0] = 29;
        cmd[1] = 40;
        cmd[2] = 107;
        cmd[3] = BU.c((int)((cmd.length - 5) % 256));
        cmd[4] = BU.c((int)((cmd.length - 5) / 256));
        cmd[5] = BU.c((int)cn);
        cmd[6] = BU.c((int)fn);
        cmd[7] = BU.c((int)m);
        if (data != null) {
            System.arraycopy(data, 0, cmd, 8, data.length);
        }
        port.write(cmd);
    }
}

