/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.printer.ipp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.PrintResolution;
import javafx.print.Printer;
import javafx.print.PrinterAttributes;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.web.WebView;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.event.PrintServiceAttributeEvent;
import javax.print.event.PrintServiceAttributeListener;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.printer.KkmModule;
import ru.softlogic.hdw.dev.printer.PrintException;
import ru.softlogic.hdw.dev.printer.PrintModule;
import ru.softlogic.hdw.dev.printer.PrintSpooler;
import ru.softlogic.hdw.dev.printer.ipp.IppPrtOptions;
import ru.softlogic.hdw.dev.printer.spooler.PrintSpoolerDriver;
import ru.softlogic.hdw.handling.DeviceInfo;

public class IppPrintSpoolerDriver
extends BaseDevice
implements PrintSpoolerDriver,
PrintSpooler,
Runnable,
PrintModule,
PrintServiceAttributeListener {
    private static final String BASE_VERSION = "c2.0.0";
    private final String name;
    private final List<Thread> threads;
    private final Logger log;
    private int lastQueueSize;
    private final BlockingQueue<ru.softlogic.hdw.dev.printer.spooler.PrinterJob> jobs;
    private Printer prn;
    private PageLayout pl;
    private WebView wv;
    private final Object sync = new Object();
    private boolean finished;

    public IppPrintSpoolerDriver(String name, IppPrtOptions options, Logger log) {
        super(new DeviceId(1, "ipp", 0), BASE_VERSION, log);
        this.name = name;
        this.log = log;
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(ipp)"));
        this.jobs = new LinkedBlockingQueue<ru.softlogic.hdw.dev.printer.spooler.PrinterJob>();
    }

    @Override
    public void print(ru.softlogic.hdw.dev.printer.spooler.PrinterJob job) {
        if (job == null) {
            throw new NullPointerException("PrinterJob is null");
        }
        this.jobs.add(job);
    }

    @Override
    public PrintSpooler getPrintSpooler() {
        return this;
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public void run() {
        this.log.info((Object)"Start");
        try {
            this.init();
            while (!Thread.currentThread().isInterrupted()) {
                ru.softlogic.hdw.dev.printer.spooler.PrinterJob pj = this.jobs.take();
                pj.print(this);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            this.log.info((Object)"Interupted");
        }
        this.log.info((Object)"Stop");
    }

    @Override
    public KkmModule getKkmModule() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(String text) throws PrintException, IOException {
        this.log.info((Object)("Print text: " + text));
        if (text != null && !text.isEmpty()) {
            String[] docs = text.split("<cut/>");
            this.log.info((Object)("Total docs: " + docs.length));
            for (String doc : docs) {
                this.finished = false;
                Platform.runLater((Runnable)new ContentLoader(doc));
                this.log.info((Object)"Content send, expect the download is complete");
                try {
                    Object object = this.sync;
                    synchronized (object) {
                        if (!this.finished) {
                            this.sync.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                this.log.info((Object)"Download is complete");
                PrinterJob job = PrinterJob.createPrinterJob((Printer)this.prn);
                if (job != null) {
                    job.jobStatusProperty().addListener((ChangeListener)new PrinterJobListener());
                    this.log.info((Object)"Send it to printer");
                    boolean success = job.printPage(this.pl, (Node)this.wv);
                    this.log.info((Object)("Is succes: " + success));
                    if (success) {
                        job.endJob();
                    }
                }
                this.log.info((Object)"Done");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws InterruptedException {
        this.log.info((Object)("Init printer: " + this.name));
        PrintService service = null;
        if (this.name != null && !this.name.isEmpty()) {
            for (Object pr : Printer.getAllPrinters()) {
                if (!pr.getName().equals(this.name)) continue;
                this.prn = pr;
                break;
            }
            PrintService[] pss = PrintServiceLookup.lookupPrintServices(null, null);
            this.log.info((Object)"Printer list:");
            for (PrintService ps : pss) {
                this.log.info((Object)ps.getName());
                if (!this.name.equals(ps.getName())) continue;
                this.log.info((Object)"found!");
                service = ps;
                break;
            }
        }
        if (this.prn == null) {
            this.prn = Printer.getDefaultPrinter();
        }
        if (service == null) {
            service = PrintServiceLookup.lookupDefaultPrintService();
        }
        if (service != null) {
            service.addPrintServiceAttributeListener(this);
            this.log.info((Object)"Add state listener");
        } else {
            this.log.error((Object)"Can't add state listener");
        }
        if (this.prn != null) {
            PrinterAttributes pa = this.prn.getPrinterAttributes();
            this.pl = this.prn.createPageLayout(pa.getDefaultPaper(), PageOrientation.PORTRAIT, 6.0, 6.0, 6.0, 6.0);
            this.log.info((Object)("Printer: " + this.prn.getName()));
            this.log.info((Object)("    Default page layout: " + this.prn.getDefaultPageLayout()));
            this.log.info((Object)("    Default copies: " + pa.getDefaultCopies()));
            this.log.info((Object)("    Default paper source: " + pa.getDefaultPaperSource()));
            this.log.info((Object)("    Supported paper sources: " + pa.getSupportedPaperSources()));
            this.log.info((Object)("    Default paper: " + pa.getDefaultPaper()));
            this.log.info((Object)"    Supported papers: ");
            for (Paper ps : pa.getSupportedPapers()) {
                this.log.info((Object)("        " + ps));
            }
            this.log.info((Object)("    Default print resolution: " + pa.getDefaultPrintResolution()));
            this.log.info((Object)"    Supported resolutions: ");
            for (PrintResolution pr : pa.getSupportedPrintResolutions()) {
                this.log.info((Object)("        " + pr));
            }
            this.log.info((Object)("    Default print quality: " + pa.getDefaultPrintQuality()));
            this.log.info((Object)("    Default print sides: " + pa.getDefaultPrintSides()));
            this.log.info((Object)("    Default collation: " + pa.getDefaultCollation()));
            this.log.info((Object)"    ----------------------------");
            this.log.info((Object)("    Printable size: " + this.pl.getPrintableWidth() + "x" + this.pl.getPrintableHeight() + ", border: " + this.pl.getLeftMargin() + "," + this.pl.getTopMargin() + "," + this.pl.getRightMargin() + "," + this.pl.getBottomMargin()));
            this.log.info((Object)("    Paper size: " + this.pl.getPaper().getWidth() + "x" + this.pl.getPaper().getHeight()));
            DeviceInfo di = new DeviceInfo(1, "ipp");
            di.setModel(this.prn.getName());
            Paper def = pa.getDefaultPaper();
            di.setInfo("resolution: " + pa.getDefaultPrintResolution() + ", paper: " + (int)def.getWidth() + "x" + (int)def.getHeight());
            this.updateDeviceInfo(di);
            this.log.info((Object)"Create WebView");
            this.finished = false;
            Platform.runLater((Runnable)new WebViewCreator(def.getWidth(), def.getHeight()));
            Object object = this.sync;
            synchronized (object) {
                if (!this.finished) {
                    this.sync.wait();
                }
            }
            this.log.info((Object)"WebView create successfully");
            this.updateState(0);
        } else {
            this.log.error((Object)"Printer not found");
            this.updateState(-1);
        }
    }

    @Override
    public short getPrinterClass() {
        return 1;
    }

    @Override
    public void attributeUpdate(PrintServiceAttributeEvent psae) {
        Attribute[] attrs;
        this.log.debug((Object)("Printer state is change: " + psae));
        for (Attribute attr : attrs = psae.getAttributes().toArray()) {
            this.log.debug((Object)("Attribute is change: " + attr.getCategory().getCanonicalName()));
            if (attr.getCategory().isAssignableFrom(PrinterIsAcceptingJobs.class)) {
                PrinterIsAcceptingJobs piaj = (PrinterIsAcceptingJobs)attr;
                if (!piaj.equals(PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS)) continue;
                this.updateState(-7);
                continue;
            }
            if (!attr.getCategory().isAssignableFrom(QueuedJobCount.class)) continue;
            QueuedJobCount cnt = (QueuedJobCount)attr;
            if (cnt.getValue() != this.lastQueueSize) {
                this.lastQueueSize = cnt.getValue();
                this.log.info((Object)("Print queue size: " + cnt.getValue()));
            }
            if (cnt.getValue() >= 2) {
                this.log.info((Object)"Too many stored payments");
                this.updateState(-7);
                continue;
            }
            this.updateState(0);
        }
    }

    private class WebviewListener
    implements ChangeListener<Worker.State> {
        private WebviewListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
            IppPrintSpoolerDriver.this.log.info((Object)("Web view state changed: " + oldState + "->" + newState));
            if (newState == Worker.State.SUCCEEDED || newState == Worker.State.CANCELLED) {
                Object object = IppPrintSpoolerDriver.this.sync;
                synchronized (object) {
                    IppPrintSpoolerDriver.this.finished = true;
                    IppPrintSpoolerDriver.this.sync.notifyAll();
                }
            }
        }
    }

    private class ContentLoader
    implements Runnable {
        private final String content;

        public ContentLoader(String content) {
            this.content = content;
        }

        @Override
        public void run() {
            IppPrintSpoolerDriver.this.log.info((Object)"Load template");
            IppPrintSpoolerDriver.this.wv.getEngine().loadContent(this.content);
            IppPrintSpoolerDriver.this.log.info((Object)"Done");
        }
    }

    private class PrinterJobListener
    implements ChangeListener<PrinterJob.JobStatus> {
        private PrinterJobListener() {
        }

        public void changed(ObservableValue<? extends PrinterJob.JobStatus> ov, PrinterJob.JobStatus oldState, PrinterJob.JobStatus newState) {
            IppPrintSpoolerDriver.this.log.info((Object)("Printer job state changed: " + oldState + "->" + newState));
        }
    }

    private class WebViewCreator
    implements Runnable {
        private final double width;
        private final double height;

        public WebViewCreator(double width, double height) {
            this.width = width;
            this.height = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IppPrintSpoolerDriver.this.log.info((Object)"Try to create webview");
            IppPrintSpoolerDriver.this.wv = new WebView();
            IppPrintSpoolerDriver.this.log.info((Object)("Done, set size: " + this.width + "x" + this.height));
            IppPrintSpoolerDriver.this.wv.setPrefSize(this.width, this.height);
            IppPrintSpoolerDriver.this.wv.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new WebviewListener());
            Object object = IppPrintSpoolerDriver.this.sync;
            synchronized (object) {
                IppPrintSpoolerDriver.this.finished = true;
                IppPrintSpoolerDriver.this.sync.notifyAll();
            }
        }
    }
}

