/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.ioc;

import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.ioc.IOControllerDriver;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class IOControllerFactory
extends BaseFactory {
    private IOControllerFactory() {
    }

    public static IOControllerDriver createDriver(String type, SerialPort port, Logger log) throws CreatingException {
        IOControllerFactory.check(type, (Port)port, log);
        String pkg = "ru.softlogic.hardware.ioc." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            IOControllerDriver cr = (IOControllerDriver)cl.getConstructor(SerialPort.class, Logger.class).newInstance(port, log);
            return cr;
        }
        catch (ClassNotFoundException ex) {
            throw new CreatingException(ex);
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }
}

