/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp.init;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.dev.epp.KeyTag;
import ru.softlogic.hdw.dev.epp.init.CancelException;
import ru.softlogic.hdw.dev.epp.init.KeyVerifyException;
import ru.softlogic.hdw.dev.epp.init.ManualKeyInHandler;
import ru.softlogic.hdw.dev.epp.init.ManualKeyInListener;

public abstract class BaseManualKeyInHandler
implements ManualKeyInHandler {
    protected final Logger log;
    protected KeyTag keyTag;
    protected ManualKeyInListener processListener;
    protected int comleteLen;

    public BaseManualKeyInHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void init(KeyTag keyTag, int keyLen, ManualKeyInListener listener) {
        this.keyTag = keyTag;
        this.comleteLen = keyLen;
        this.processListener = listener;
    }

    @Override
    public final void run() {
        if (this.processListener == null) {
            this.log.error((Object)"Manual Key In Handler not init");
            throw new IllegalArgumentException("Manual Key In Handler not init");
        }
        this.log.info((Object)"Start handler");
        try {
            this.runImpl();
        }
        catch (IOException ex) {
            this.processListener.onError(4);
        }
        catch (TimeoutException ex) {
            this.log.error((Object)"Notify timeout");
            this.processListener.onError(1);
        }
        catch (CancelException ex) {
            this.log.error((Object)"Notify cancel");
            this.processListener.onError(2);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (KeyVerifyException ex) {
            this.processListener.onError(7);
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            this.processListener.onError(10);
        }
        this.log.info((Object)"Handler done");
    }

    protected abstract void runImpl() throws IOException, TimeoutException, CancelException, InterruptedException, KeyVerifyException, Exception;
}

