/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.TaskBus;
import ru.softlogic.hdw.base.BaseDevice;
import ru.softlogic.hdw.dev.epp.CryptoApi;
import ru.softlogic.hdw.dev.epp.EncryptedPinPad;
import ru.softlogic.hdw.dev.epp.EppDriver;
import ru.softlogic.hdw.dev.epp.EppKeyListener;
import ru.softlogic.hdw.dev.epp.EppOptions;
import ru.softlogic.hdw.dev.epp.KeyNotFoundException;
import ru.softlogic.hdw.dev.epp.KeyTag;
import ru.softlogic.hdw.dev.epp.PinblockRequest;
import ru.softlogic.hdw.dev.epp.PlainPinRequest;
import ru.softlogic.hdw.dev.epp.ReleaseApi;
import ru.softlogic.hdw.dev.epp.UIDStore;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.utils.SerialFmt;

public abstract class BaseEpp
extends BaseDevice
implements EncryptedPinPad,
EppDriver,
Runnable {
    private static final String BASE_VERSION = "1.0.1";
    private final List<Thread> threads;
    protected SerialPort port;
    protected volatile int deviceMode = 0;
    protected CryptoApi cryptoApi;
    protected ReleaseApi pinblockApi;
    protected ReleaseApi openPinblockApi;
    protected UIDStore store;
    protected PinblockRequest pinblockRequest;
    protected PlainPinRequest plainPinRequest;
    protected EppKeyListener eppKeyListener;
    protected final TaskBus bus;
    protected Logger log;
    private final EppOptions eppOptions;

    public BaseEpp(DeviceId deviceId, SerialPort port, Logger log, UIDStore store, EppOptions eppOptions) {
        super(deviceId, BASE_VERSION, log);
        this.port = port;
        this.log = log;
        this.eppOptions = eppOptions;
        this.bus = new TaskBus(log);
        this.threads = new LinkedList<Thread>();
        this.threads.add(new Thread((Runnable)this, "drv(" + deviceId.getType() + ")"));
        this.threads.add(new Thread((Runnable)this.bus, "DriverTaskBus"));
    }

    public BaseEpp(DeviceId deviceId, String baseDrvVersion, Logger log, EppOptions eppOptions) {
        this(deviceId, null, log, null, eppOptions);
    }

    @Override
    public EncryptedPinPad getEpp() {
        return this;
    }

    @Override
    public List<Thread> getThreads() {
        return this.threads;
    }

    @Override
    public final void run() {
        this.log.info((Object)"Start encrypted PINPad driver");
        if (this.port != null) {
            this.log.info((Object)("Port: " + SerialFmt.format((SerialPort)this.port)));
        }
        this.log.info((Object)("Driver: " + this.getDeviceId().getType() + ", number: " + this.getDeviceId().getNumber()));
        try {
            this._run();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (this.port != null) {
            this.port.close();
        }
        this.log.info((Object)"Stop thread");
    }

    protected abstract void _run() throws InterruptedException;

    protected abstract void _changeMode(int var1) throws IOException, InterruptedException;

    @Override
    public synchronized int getMode() {
        return this.deviceMode;
    }

    @Override
    public synchronized void disable() {
        if (this.modeIsExclusive()) {
            throw new IllegalStateException("The device is used in exclusive mode");
        }
        this.changeState(0);
    }

    protected void changeMode(int mode) {
        block4: {
            try {
                this._changeMode(mode);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                this.log.warn((Object)ex.getMessage());
                if (mode == 3 && this.pinblockRequest != null) {
                    this.pinblockRequest.getListener().onError(4);
                }
                if (mode != 4 || this.plainPinRequest == null) break block4;
                this.plainPinRequest.getListener().onError(4);
            }
        }
    }

    @Override
    public synchronized void selectOpenMode(EppKeyListener listener) {
        if (this.modeIsExclusive()) {
            throw new IllegalStateException("The device is used in exclusive mode");
        }
        this.eppKeyListener = listener;
        this.changeState(1);
    }

    @Override
    public synchronized CryptoApi selectCryptoMode() {
        if (this.modeIsExclusive()) {
            throw new IllegalStateException("The device is used in exclusive mode");
        }
        if (this.deviceMode == 2) {
            throw new IllegalStateException("The device is in this state");
        }
        this.changeState(2);
        return this.cryptoApi;
    }

    @Override
    public synchronized ReleaseApi selectPinBlockMode(PinblockRequest request) {
        if (this.modeIsExclusive()) {
            throw new IllegalStateException("The device is used in exclusive mode");
        }
        if (this.deviceMode == 3) {
            throw new IllegalStateException("The device is in this state");
        }
        this.changeState(3);
        this.pinblockRequest = request;
        return this.pinblockApi;
    }

    @Override
    public synchronized ReleaseApi selectPlainPinMode(PlainPinRequest request) {
        if (this.modeIsExclusive()) {
            throw new IllegalStateException("The device is used in exclusive mode");
        }
        if (this.deviceMode == 4) {
            throw new IllegalStateException("The device is in this state");
        }
        this.changeState(4);
        this.plainPinRequest = request;
        return this.openPinblockApi;
    }

    protected synchronized boolean modeIsExclusive() {
        return this.deviceMode == 3 || this.deviceMode == 2 || this.deviceMode == 4;
    }

    protected void addThread(Thread thread) {
        if (thread == null) {
            throw new NullPointerException("Thread is null");
        }
        this.threads.add(thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeState(int newState) {
        BaseEpp baseEpp = this;
        synchronized (baseEpp) {
            this.deviceMode = newState;
            this.bus.addTask(new EppModeNotifier(newState));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEppKeyListener(EppKeyListener eppKeyListener) {
        BaseEpp baseEpp = this;
        synchronized (baseEpp) {
            this.eppKeyListener = eppKeyListener;
        }
    }

    @Override
    public EppOptions getOptions() {
        return this.eppOptions;
    }

    protected void checkPinMk() throws IOException {
        try {
            this.getKcv(1, KeyTag.PinKey);
        }
        catch (KeyNotFoundException ex) {
            this.notifyProblemOnce("Master key " + (Object)((Object)KeyTag.PinKey) + " is not found");
        }
    }

    private class EppModeNotifier
    implements Runnable {
        private final int mode;

        public EppModeNotifier(int mode) {
            this.mode = mode;
        }

        @Override
        public void run() {
            BaseEpp.this.changeMode(this.mode);
        }
    }
}

