/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp.impl;

import ru.softlogic.hdw.dev.epp.CryptoApi;
import ru.softlogic.hdw.dev.epp.CryptoException;
import ru.softlogic.hdw.dev.epp.EncryptMode;
import ru.softlogic.hdw.dev.epp.KeyTag;
import ru.softlogic.hdw.dev.epp.MacMode;
import ru.softlogic.hdw.dev.epp.impl.BaseEpp;

public abstract class BaseCryptoApi
implements CryptoApi {
    private final BaseEpp epp;
    private boolean isReleased = false;

    public BaseCryptoApi(BaseEpp epp) {
        this.epp = epp;
    }

    @Override
    public byte[] mac(MacMode mode, byte[] data, int length) throws CryptoException {
        this.checkLock();
        if (mode == null) {
            throw new NullPointerException("MacMode is not set");
        }
        if (data == null) {
            throw new NullPointerException("Data is not set");
        }
        return null;
    }

    @Override
    public byte[] mac(byte[] data, int length) throws CryptoException {
        this.checkLock();
        if (data == null) {
            throw new NullPointerException("Data is not set");
        }
        return null;
    }

    @Override
    public byte[] encrypt(EncryptMode mode, byte[] data) throws CryptoException {
        this.checkLock();
        return null;
    }

    @Override
    public byte[] decrypt(EncryptMode mode, byte[] data) throws CryptoException {
        this.checkLock();
        return null;
    }

    @Override
    public void loadWorkKey(KeyTag keyTag, byte[] key) throws CryptoException {
        this.checkLock();
    }

    @Override
    public void release() {
        this.checkLock();
        this.isReleased = true;
        this.epp.changeState(0);
        this.epp.setEppKeyListener(null);
    }

    private void checkLock() {
        if (this.isReleased) {
            throw new IllegalArgumentException("Control is lost");
        }
    }
}

