/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp;

public class EppSystemProp {
    public static final boolean isEppReset() {
        return Boolean.parseBoolean(System.getProperty("epp.reinit.reset"));
    }

    public static final int getPortResetFreq() {
        return EppSystemProp.getIntValue("epp.reinit.freq", 0, 0, 24);
    }

    private static int getIntValue(String key, int def, int min, int max) {
        int value = def;
        String property = System.getProperty(key);
        try {
            if (property != null) {
                value = Integer.parseInt(property);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return EppSystemProp.checkRange(value, min, max);
    }

    private static int checkRange(int val, int min, int max) {
        if (min > 0 && val < min) {
            return min;
        }
        if (max > 0 && val > max) {
            return max;
        }
        return val;
    }
}

