/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.epp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CardUtil {
    private static final String MASK12 = "************";
    private static final String MASK6 = "******";

    private CardUtil() {
    }

    public static String getPanForIso0(String pan) {
        CardUtil.checkPan(pan);
        return "0000" + pan.substring(pan.length() - 13, pan.length() - 1);
    }

    public static String getPanForDoc(String pan) {
        CardUtil.checkPan(pan);
        return CardUtil.getMaskByLen(pan.length() - 4) + pan.substring(pan.length() - 4);
    }

    public static String getPan64(String pan) {
        CardUtil.checkPan(pan);
        return pan.substring(0, 6) + CardUtil.getMaskByLen(pan.length() - 10) + pan.substring(pan.length() - 4);
    }

    public static String getClient(String track1) {
        if (track1 == null) {
            throw new NullPointerException("track1");
        }
        Matcher m = Pattern.compile("\\^((\\w|\\.|-|/)+)\\^").matcher(track1);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private static String getMaskByLen(int len) {
        if (len == 12) {
            return MASK12;
        }
        StringBuilder sb = new StringBuilder(len > 12 ? MASK12 : MASK6);
        while (sb.length() < len) {
            sb.append('*');
        }
        return sb.toString();
    }

    private static void checkPan(String pan) {
        if (pan == null) {
            throw new NullPointerException("Pan");
        }
        if (pan.length() < 16 || pan.length() > 18) {
            throw new IllegalArgumentException("Pan length must be in range [16..18] symbols");
        }
    }
}

