/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.cvd;

import java.util.Properties;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.BaseFactory;
import ru.softlogic.hdw.CreatingException;
import ru.softlogic.hdw.dev.cvd.CardDispenserDriver;
import ru.softlogic.hdw.dev.cvd.CvdDescriptor;
import ru.softlogic.hdw.dev.cvd.CvdOptions;
import ru.softlogic.io.Port;
import ru.softlogic.io.serial.SerialPort;

public class CardDispenserFactory
extends BaseFactory {
    private CardDispenserFactory() {
    }

    public static CardDispenserDriver createDriver(String type, SerialPort port, CvdOptions options, Logger log) throws CreatingException {
        CardDispenserFactory.check(type, (Port)port, log);
        if (options == null) {
            throw new NullPointerException("Options is not set");
        }
        String pkg = "ru.softlogic.hardware.cvd." + type.toLowerCase() + ".driver.Driver";
        try {
            Class<?> cl = Class.forName(pkg);
            CardDispenserDriver cr = (CardDispenserDriver)cl.getConstructor(SerialPort.class, String.class, CvdOptions.class, Logger.class).newInstance(port, type, options, log);
            return cr;
        }
        catch (Exception ex) {
            throw new CreatingException(ex);
        }
    }

    public static CvdOptions createDefaultOptions(String type) throws CreatingException {
        Properties prop = CardDispenserFactory.getParamProperties("cvd", type);
        int mc = CardDispenserFactory.getIntParam(prop, "capacity.main");
        int rc = CardDispenserFactory.getIntParam(prop, "capacity.reject");
        int to = CardDispenserFactory.getIntParam(prop, "timeout");
        return new CvdOptions(mc, rc, to, false, false);
    }

    public static CvdOptions createDefaultOptionsQuietly(String type) {
        try {
            return CardDispenserFactory.createDefaultOptions(type);
        }
        catch (CreatingException ex) {
            return CvdOptions.DEFAULT;
        }
    }

    public static CvdDescriptor createDescriptor(String type) throws CreatingException {
        return new CvdDescriptor(CardDispenserFactory.getFeaturesQuetly("features", type));
    }

    public static CvdDescriptor createDescriptorQuietly(String type) {
        try {
            return CardDispenserFactory.createDescriptor(type);
        }
        catch (CreatingException e) {
            return CvdDescriptor.DEFALT;
        }
    }
}

