/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd.pcsc;

import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.apache.log4j.Logger;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.dev.crd.APDUResponse;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdw.dev.crd.Description;
import ru.softlogic.hdw.dev.crd.IcApi;
import ru.softlogic.hdw.dev.crd.impl.ManualInsertionDriver;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.io.utils.BU;

public class Driver
extends ManualInsertionDriver {
    private static final String VERSION = "1.0.0";
    private boolean lastState;
    private boolean errorFlag;
    private final Description cardDescription;
    private Card card;
    private CardTerminal terminal;
    private CardChannel channel;

    public Driver(CardTerminal terminal, Logger log) {
        super(new DeviceId(7, "ps/sc", 0), "2.0", log);
        if (terminal == null) {
            throw new NullPointerException("CardTerminal is not set");
        }
        if (log == null) {
            throw new NullPointerException("Logger is not set");
        }
        this.terminal = terminal;
        this.log = log;
        this.icApi = new ICcardAPI();
        this.cardDescription = new Description(4);
        this.errorFlag = true;
    }

    @Override
    public Description getDescription() {
        return this.cardDescription;
    }

    @Override
    public IcApi getIcApi() {
        this.log.info((Object)"Getting IcCard API");
        return this.icApi;
    }

    @Override
    public void ejectCard() throws CardReaderException {
        super.ejectCard();
    }

    public void resetCard() throws CardException {
        if (this.terminal.isCardPresent()) {
            this.card.disconnect(false);
        }
        this.card = this.terminal.connect("*");
        this.channel = this.card.getBasicChannel();
    }

    protected void init() throws IOException {
        DeviceInfo di = this.createDeviceInfo();
        di.setDeviceType("crd");
        this.updateDeviceInfo(di);
        this.updateState(new DeviceState(7, 0));
        this.errorFlag = false;
    }

    private void checkState() throws CardException {
        boolean currState = this.terminal.isCardPresent();
        if (currState != this.lastState) {
            this.lastState = currState;
            if (this.lastState && this.enabled) {
                this.card = this.terminal.connect("*");
                this.channel = this.card.getBasicChannel();
                this.updateCardState(1);
                this.updateCardState(2);
            } else if (!this.lastState) {
                this.updateCardState(4);
                this.updateCardState(0);
            }
        }
    }

    @Override
    public void release() {
        this.cardStateListener = null;
    }

    @Override
    public void _run() {
        this.log.info((Object)"Start thread");
        this.log.info((Object)("Thread ID: " + Thread.currentThread().getId()));
        this.log.info((Object)"Driver: SmartCardIO Driver");
        this.log.info((Object)"Version: 1.0.0");
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    if (this.errorFlag) {
                        this.init();
                    }
                    this.checkState();
                    this.onConnSuccess();
                    this.sleep(1000);
                }
                catch (Exception ex) {
                    this.log.error((Object)"PS/SC Error", (Throwable)ex);
                    this.onConnError(ex);
                    this.errorFlag = true;
                    this.randomSleep(500, 500);
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        this.log.info((Object)"Stop thread");
    }

    private static CommandAPDU createCommandAPDU(byte[] cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException("Argument 'cmd' cannot be null");
        }
        if (cmd.length < 4) {
            throw new IllegalArgumentException("APDU must be at least 4 bytes long: " + cmd.length);
        }
        CommandAPDU commandAPDU = null;
        if (cmd.length == 4) {
            commandAPDU = new CommandAPDU(cmd);
        } else if (cmd.length == 5) {
            commandAPDU = new CommandAPDU(BU.c((byte)cmd[0]), BU.c((byte)cmd[1]), BU.c((byte)cmd[2]), BU.c((byte)cmd[3]), cmd[4] == 0 ? 256 : BU.c((byte)cmd[4]));
        } else if (cmd.length == 5 + BU.c((byte)cmd[4])) {
            commandAPDU = new CommandAPDU(cmd);
        } else if (cmd.length == 5 + BU.c((byte)cmd[4]) + 1) {
            byte[] data = new byte[BU.c((byte)cmd[4])];
            System.arraycopy(cmd, 5, data, 0, data.length);
            int le = BU.c((byte)cmd[cmd.length - 1]);
            commandAPDU = new CommandAPDU(BU.c((byte)cmd[0]), BU.c((byte)cmd[1]), BU.c((byte)cmd[2]), BU.c((byte)cmd[3]), data, 0, data.length, le == 0 ? 256 : le);
        } else {
            throw new IllegalArgumentException("Unsupported APDU format: " + BU.toString((byte[])cmd));
        }
        return commandAPDU;
    }

    private class ICcardAPI
    implements IcApi {
        private ICcardAPI() {
        }

        @Override
        public byte[] getATR() {
            try {
                if (Driver.this.card == null) {
                    Driver.this.resetCard();
                    if (Driver.this.card == null) {
                        return null;
                    }
                }
            }
            catch (CardException ex) {
                Driver.this.log.warn((Object)"Get ATR error.", (Throwable)ex);
            }
            return Driver.this.card.getATR().getBytes();
        }

        public APDUResponse transmit(CommandAPDU cmd) throws CardReaderException {
            CommandAPDU scioCommandAPDU = cmd;
            try {
                ResponseAPDU apdu = Driver.this.channel.transmit(scioCommandAPDU);
                byte sw1 = (byte)apdu.getSW1();
                byte sw2 = (byte)apdu.getSW2();
                byte[] data = apdu.getData();
                return new APDUResponse(data, sw1, sw2);
            }
            catch (CardException ex) {
                throw new CardReaderException("Error occurred while transmitting command: " + BU.toHexString((byte[])scioCommandAPDU.getBytes()), ex);
            }
        }

        @Override
        public APDUResponse transmit(byte[] bytes) throws CardReaderException {
            return this.transmit(Driver.createCommandAPDU(bytes));
        }
    }
}

