/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.hdw.dev.crd.impl;

import java.util.List;
import ru.softlogic.hdw.BusyException;
import ru.softlogic.hdw.DeviceId;
import ru.softlogic.hdw.base.UpdateApi;
import ru.softlogic.hdw.dev.crd.CardReader;
import ru.softlogic.hdw.dev.crd.CardReaderException;
import ru.softlogic.hdw.dev.crd.CardReaderStore;
import ru.softlogic.hdw.dev.crd.CardStateListener;
import ru.softlogic.hdw.dev.crd.CustomApi;
import ru.softlogic.hdw.dev.crd.Description;
import ru.softlogic.hdw.dev.crd.IcApi;
import ru.softlogic.hdw.dev.crd.MagneticApi;
import ru.softlogic.hdw.dev.crd.MotorApi;
import ru.softlogic.hdw.dev.sensors.Sensor;
import ru.softlogic.hdw.handling.DeviceInfo;
import ru.softlogic.hdw.handling.DeviceInfoListener;
import ru.softlogic.hdw.handling.DeviceProblemListener;
import ru.softlogic.hdw.handling.DeviceState;
import ru.softlogic.hdw.handling.DeviceStateListener;

public class CardReaderStorage
implements CardReaderStore {
    private final CardReader cardReader;
    private boolean exclusive;

    public CardReaderStorage(CardReader cardReader) {
        this.cardReader = new CardReaderProxy(cardReader);
    }

    @Override
    public CardReader getCardReader(boolean exclusive) throws BusyException {
        if (this.exclusive) {
            throw new BusyException("The cardreader already busy");
        }
        this.exclusive = exclusive;
        return this.cardReader;
    }

    private class CardReaderProxy
    implements CardReader {
        private final CardReader cardReader;
        private boolean isReleased;

        public CardReaderProxy(CardReader cardReader) {
            this.cardReader = cardReader;
            this.isReleased = false;
        }

        @Override
        public void enableDevice(CardStateListener cardStateListener) {
            this.checkLock();
            this.cardReader.enableDevice(cardStateListener);
        }

        @Override
        public void disableDevice() {
            this.checkLock();
            this.cardReader.disableDevice();
        }

        @Override
        public boolean isEnabled() {
            this.checkLock();
            return this.cardReader.isEnabled();
        }

        @Override
        public void release() {
            this.checkLock();
            if (CardReaderStorage.this.exclusive) {
                CardReaderStorage.this.exclusive = false;
            }
            this.isReleased = true;
            this.cardReader.release();
        }

        @Override
        public void ejectCard() throws CardReaderException {
            this.checkLock();
            this.cardReader.ejectCard();
        }

        @Override
        public Description getDescription() {
            this.checkLock();
            return this.cardReader.getDescription();
        }

        @Override
        public MagneticApi getMagneticApi() {
            this.checkLock();
            return this.cardReader.getMagneticApi();
        }

        @Override
        public IcApi getIcApi() throws CardReaderException {
            this.checkLock();
            return this.cardReader.getIcApi();
        }

        @Override
        public MotorApi getMotorApi() {
            this.checkLock();
            return this.cardReader.getMotorApi();
        }

        @Override
        public DeviceState getLastState() {
            this.checkLock();
            return this.cardReader.getLastState();
        }

        @Override
        public void addStateListener(DeviceStateListener dl) {
            this.checkLock();
            this.cardReader.addStateListener(dl);
        }

        @Override
        public void removeStateListener(DeviceStateListener dl) {
            this.checkLock();
            this.cardReader.removeStateListener(dl);
        }

        @Override
        public DeviceInfo getLastInfo() {
            this.checkLock();
            return this.cardReader.getLastInfo();
        }

        @Override
        public void addDeviceInfoListener(DeviceInfoListener dl) {
            this.checkLock();
            this.cardReader.addDeviceInfoListener(dl);
        }

        @Override
        public void removeDeviceInfoListener(DeviceInfoListener dl) {
            this.checkLock();
            this.cardReader.removeDeviceInfoListener(dl);
        }

        @Override
        public void addDeviceProblemListener(DeviceProblemListener dl) {
            this.checkLock();
            this.cardReader.addDeviceProblemListener(dl);
        }

        @Override
        public void removeDeviceProblemListener(DeviceProblemListener dl) {
            this.checkLock();
            this.cardReader.removeDeviceProblemListener(dl);
        }

        private void checkLock() {
            if (this.isReleased) {
                throw new IllegalArgumentException("Control is lost");
            }
        }

        @Override
        public UpdateApi getUpdateApi() {
            return null;
        }

        @Override
        public List<Sensor> getSensors() {
            return null;
        }

        @Override
        public CustomApi getCustomApi() {
            return null;
        }

        @Override
        public boolean isOperable() {
            this.checkLock();
            return this.cardReader.isOperable();
        }

        @Override
        public int getCurrentCardState() {
            this.checkLock();
            return this.cardReader.getCurrentCardState();
        }

        @Override
        public DeviceId getDeviceId() {
            return null;
        }
    }
}

